% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-detect_haemoglobinaemia.R
\name{detect_anaemia_u5}
\alias{detect_anaemia_u5}
\alias{detect_anaemia_5to11}
\alias{detect_anaemia_12to14}
\alias{detect_anaemia_np_women}
\alias{detect_anaemia_pregnant}
\alias{detect_anaemia_men}
\alias{detect_anaemia}
\title{Determine haemoglobinaemia status for various population groups}
\usage{
detect_anaemia_u5(hb = NULL, label = TRUE)

detect_anaemia_5to11(hb = NULL, label = TRUE)

detect_anaemia_12to14(hb = NULL, label = TRUE)

detect_anaemia_np_women(hb = NULL, label = TRUE)

detect_anaemia_pregnant(hb = NULL, label = TRUE)

detect_anaemia_men(hb = NULL, label = TRUE)

detect_anaemia(
  hb = NULL,
  group = c("u5", "5to11", "12to14", "np_women", "pregnant", "men"),
  label = TRUE
)
}
\arguments{
\item{hb}{A numeric value or numeric vector containing haemoglobin values in
grams per litre (g/L).}

\item{label}{Logical. Should labels be used to classify haemoglobinaemia?
If TRUE (default), status is classified as "no anaemia", "mild anaemia",
"moderate anaemia", or "severe anaemia". If FALSE, simple integer codes
are returned: 0 for no anaemia; 1 for mild anaemia; 2 for moderate anaemia;
3 for severe anaemia.}

\item{group}{A character value specifying the population target group to
identify haemoglobinaemia from. Can be either one of \strong{u5}, \strong{5to11},
\strong{11to14}, \strong{np_women}, \strong{pregnant}, or \strong{men}. Default is \strong{u5}.}
}
\value{
If \code{label} is TRUE, a character value or character vector of
haemoglobinaemia status classification (can be either "severe anaemia" or
"moderate anaemia", "mild anaemia", or "no anaemia"). If \code{label} is FALSE,
an integer value or integer vector of haemoglobinaemia status
classification (0 = no anaemia; 1 = mild anaemia; 2 = moderate anaemia;
3 = severe anaemia)
}
\description{
This set of functions identifies haemoglobinaemia in specific target groups
such as children under 5 years (\strong{u5}), children 5-11 years of age
(\strong{5to11}), children 12-14 years of age (\strong{12to14}), non-pregnant women 15
years and above (\strong{np_women}), pregnant women (\strong{pregnant}), and men
(\strong{men}).
}
\examples{
x <- subset(mnData, age < 5)
detect_anaemia_u5(hb = x$hb * 10)
detect_anaemia_u5(hb = x$hb * 10, label = FALSE)
detect_anaemia(hb = x$hb * 10)
detect_anaemia(hb = x$hb * 10, label = FALSE)

}
\author{
Nicholus Tint Zaw and Ernest Guevarra
}
