% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-correct_ferritin.R
\name{correct_ferritin}
\alias{correct_ferritin}
\title{Correct serum ferritin values}
\usage{
correct_ferritin(crp = NULL, agp = NULL, ferritin = NULL)
}
\arguments{
\item{crp}{A numeric value or numeric vector for serum c-reactive protein in
micrograms per litre (microgram/l).}

\item{agp}{A numeric value or numeric vector for serum
alpha(1)-acid-glycoprotein in micrograms per litre (microgram/l).}

\item{ferritin}{A numeric value or numeric vector for serum ferritin in
micrograms per litre (microgram/l).}
}
\value{
A numeric value or numeric vector for corrected serum ferritin in
micrograms per litre (microgram/l).
}
\description{
Based on inflammation status, correct serum ferritin values as described in
Namaste, S. M., Rohner, F., Huang, J., Bhushan, N. L., Flores-Ayala, R.,
Kupka, R., Mei, Z., Rawat, R., Williams, A. M., Raiten, D. J.,
Northrop-Clewes, C. A., & Suchdev, P. S. (2017). Adjusting ferritin
concentrations for inflammation: Biomarkers Reflecting Inflammation and
Nutritional Determinants of Anemia (BRINDA) project. The American journal of
clinical nutrition, 106(Suppl 1), 359S–371S.
https://doi.org/10.3945/ajcn.116.141762
}
\examples{
correct_ferritin(
  crp = mnData$crp, ferritin = mnData$ferritin
)

}
\author{
Nicholus Tint Zaw and Ernest Guevarra
}
