% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcMI.R
\name{pcMI}
\alias{pcMI}
\title{Estimate the Equivalence Class of a DAG Using the PC-MI Algorithm for Multiple
Imputed Data Sets}
\usage{
pcMI(
  data,
  alpha,
  labels,
  p,
  fixedGaps = NULL,
  fixedEdges = NULL,
  NAdelete = TRUE,
  m.max = Inf,
  u2pd = c("relaxed", "rand", "retry"),
  skel.method = c("stable", "original"),
  conservative = FALSE,
  maj.rule = FALSE,
  solve.confl = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{An object of type mids, which stands for 'multiply imputed
data set', typically created by a call to function mice()}

\item{alpha}{Significance level (number in (0,1) for the conditional
independence tests}

\item{labels}{(Optional) character vector of variable (or "node") names.
Typically preferred to specifying p.}

\item{p}{(Optional) number of variables (or nodes). May be specified if
labels are not, in which case labels is set to 1:p.}

\item{fixedGaps}{A logical matrix of dimension p*p. If entry \code{[i,j]} or \code{[j,i]}
(or both) are TRUE, the edge i-j is removed before starting
the algorithm. Therefore, this edge is guaranteed to be
absent in the resulting graph.}

\item{fixedEdges}{A logical matrix of dimension p*p. If entry \code{[i,j]} or \code{[j,i]}
(or both) are TRUE, the edge i-j is never considered for
removal. Therefore, this edge is guaranteed to be present
in the resulting graph}

\item{NAdelete}{If indepTest returns NA and this option is TRUE,
the corresponding edge is deleted. If this option is FALSE,
the edge is not deleted.}

\item{m.max}{Maximal size of the conditioning sets that are considered in the
conditional independence tests.}

\item{u2pd}{String specifying the method for dealing with conflicting
information when trying to orient edges (see details below).}

\item{skel.method}{Character string specifying method; the default, "stable"
provides an order-independent skeleton, see
\code{\link[pcalg:skeleton]{pcalg::skeleton()}} for details.}

\item{conservative}{Logical indicating if the conservative PC is used. See
\code{\link[pcalg:pc]{pcalg::pc()}} for details.}

\item{maj.rule}{Logical indicating that the triples shall be checked for
ambiguity using a majority rule idea, which is less strict
than the conservative PC algorithm. For more information, see
\code{\link[pcalg:pc]{pcalg::pc()}}.}

\item{solve.confl}{See \code{\link[pcalg:pc]{pcalg::pc()}} for more details.}

\item{verbose}{If TRUE, detailed output is provided.}
}
\value{
See \code{\link[pcalg:pc]{pcalg::pc()}} for more details.
}
\description{
This function is a modification of \code{\link[pcalg:pc]{pcalg::pc()}}
to be used for multiple imputation.
}
\details{
An object of class "pcAlgo" (see pcAlgo) containing an estimate of
the equivalence class of the underlying DAG.
}
\note{
This is a modified function of \code{\link[pcalg:pc]{pcalg::pc()}}
from the package 'pcalg' (Kalisch et al., 2012;
http://www.jstatsoft.org/v47/i11/).
}
\examples{

daten <- mice::ampute(windspeed)$amp

## Impute missing values
imp <- mice(daten)
pcMI(data = imp, label = colnames(imp$data), alpha = 0.01)


}
\author{
Original code by Markus Kalisch, Martin Maechler, and Diego Colombo.
Modifications by Ronja Foraita.
}
