% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussCItwd.R
\name{gaussCItwd}
\alias{gaussCItwd}
\title{Fisher's z-Test for (Conditional) Independence between Gaussian Variables with Missings}
\usage{
gaussCItwd(x, y, S = NULL, suffStat)
}
\arguments{
\item{x, y, S}{(integer) position of variable X, Y and set of variables S,
respectively, in each correlation matrix in \code{suffStat}. It is tested
whether X and Y are conditionally independent given the subset S of the
remaining variables.}

\item{suffStat}{\code{data.frame} containing the raw data.}
}
\value{
See \code{pcalg::\link[pcalg:condIndFisherZ]{gaussCItest}} for details on
Fisher's z-test. Test-wise deletion is valid if missingness does not jointly
depend on X and Y.

A p-value.
}
\description{
A wrapper for \code{pcalg::\link[pcalg:condIndFisherZ]{gaussCItest}},
to be used within \code{pcalg::\link[pcalg]{skeleton}}, \code{pcalg::\link[pcalg]{pc}} or
\code{pcalg::\link[pcalg]{fci}} when the data contain missing values. Observations
where at least one of the variables involved in the test is missing are
deleted prior to performing the test (test-wise deletion).
}
\examples{

## load data (numeric variables)
dat <- as.matrix(windspeed)

## delete some observations
set.seed(123)
dat[sample(1:length(dat), 260)] <- NA

## analyse data
# complete data:
suffcomplete <- getSuff(windspeed, test="gaussCItest")
gaussCItest(1, 2, c(4,5), suffStat = suffcomplete)

# test-wise deletion: ==========
gaussCItwd(1, 2, c(4,5), suffStat = dat)

# list-wise deletion: ==========
sufflwd <- getSuff(dat[complete.cases(dat), ], test="gaussCItest")
gaussCItest(1, 2, c(4,5), suffStat = sufflwd)

## use gaussCItwd within pcalg::pc
pc.fit <- pc(suffStat = dat, indepTest = gaussCItwd, alpha = 0.01, p = 6)
pc.fit

}
\seealso{
\code{\link[pcalg:condIndFisherZ]{pcalg::condIndFisherZ()}} for complete data, \code{\link[=gaussCItestMI]{gaussCItestMI()}} for multiply imputed data
}
