% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.measrdcm}
\alias{predict.measrdcm}
\title{Posterior draws of respondent proficiency}
\usage{
\method{predict}{measrdcm}(
  object,
  newdata = NULL,
  resp_id = NULL,
  missing = NA,
  summary = TRUE,
  probs = c(0.025, 0.975),
  force = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{measrdcm}. Generated from \code{\link[=measr_dcm]{measr_dcm()}}.}

\item{newdata}{Optional new data. If not provided, the data used to estimate
the model is scored. If provided, \code{newdata} should be a data frame with 1
row per respondent and 1 column per item. All items that appear in
\code{newdata} should appear in the data used to estimate \code{object}.}

\item{resp_id}{Optional. Variable name of a column in \code{newdata} that
contains respondent identifiers. \code{NULL} (the default) indicates that no
identifiers are present in the data, and row numbers will be used as
identifiers. If \code{newdata} is not specified and the data used to estimate
the model is scored, the \code{resp_id} is taken from the original data.}

\item{missing}{An R expression specifying how missing data in \code{data} is coded
(e.g., \code{NA}, \code{"."}, \code{-99}, etc.). The default is \code{NA}.}

\item{summary}{Should summary statistics be returned instead of the raw
posterior draws? Only relevant if the model was estimated with
\code{method = "mcmc"}. Default is \code{FALSE}.}

\item{probs}{The percentiles to be computed by the \verb{[stats::quantile()]}
function. Only relevant if the model was estimated with \code{method = "mcmc"}.
Only used if \code{summary} is \code{TRUE}.}

\item{force}{If respondent estimates have already been added to the model
object with \code{\link[=add_respondent_estimates]{add_respondent_estimates()}}, should they be recalculated.
Default is \code{FALSE}.}

\item{...}{Unused.}
}
\value{
A list with two elements: \code{class_probabilities} and
\code{attribute_probabilities}.

If summary is \code{FALSE}, each element is a tibble with the number of rows
equal to the number of draws in \code{object} with columns: \code{.chain},
\code{.iteration}, \code{.draw}, the respondent identifier, and one column of
probabilities for each of the possible classes.

If summary is \code{TRUE}, each element is a tibble with one row per respondent
and class or attribute, and columns of the respondent identifier, \code{class}
or \code{attribute}, \code{mean}, and one column for every value specified in
\code{probs}.
}
\description{
Calculate posterior draws of respondent proficiency. Optionally retain all
posterior draws or return only summaries of the distribution for each
respondent.
}
