% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfmcorr.R
\name{lfmcorr}
\alias{lfmcorr}
\title{Local mark correlation functions for homogeneous point patterns with function-valued marks.}
\usage{
lfmcorr(X,
ftype = c("variogram", "stoyan", "rcorr", "shimatani", "beisbart",
 "isham", "stoyancov", "schlather"),
r = NULL,
method = c("density","loess"),
normalise = TRUE,
f = NULL,
tol = 0.01,
...)
}
\arguments{
\item{X}{An object of class ppp or lpp.}

\item{ftype}{Type of the test function \eqn{t_f}. Currently any selection of \code{"variogram", "stoyan", "rcorr", "shimatani", "beisbart", "isham", "stoyancov", "schlather"}.}

\item{r}{Optional. The values of the argument \eqn{r} at which the mark correlation function should be evaluated.}

\item{method}{Type of smoothing, either \code{density} or \code{loess}. See details.}

\item{normalise}{If \code{normalise=FALSE}, only the numerator of the expression for the mark correlation function will be computed.}

\item{f}{Optional. Test function \eqn{t_f} used in the definition of the mark correlation function. If \code{ftype} is given, \eqn{t_f} should be \code{NULL}.}

\item{tol}{Tolerance used in the calculation of the conditional mean of the marks. This is used only if \code{ftype} is \code{schlather}.}

\item{...}{Arguments passed to \code{\link[spatstat.univar]{unnormdensity}} or \code{\link[stats]{loess}}.}
}
\value{
a data.frame which gives the estimated overall local mark correlation function and the distance vector \eqn{r} at which the local mark correlation function is estimated. The outputs of the local mark correlation functions for each time point are stored as an attribute, which can be extracted as \code{attr(., "ests.time")}.
The outputs of the local mark correlation functions for each data point are stored as an attribute, which can be extracted as \code{attr(., "ests.points")}.
}
\description{
Local mark correlation functions for homogeneous point patterns with function-valued marks.
}
\details{
This function computes local mark correlation functions for a homogeneous point pattern with a function-valued mark. See the details of test functions used in \code{\link[markstat]{fmcorr}}. Technical details are given in Eckardt and Moradi (2025).
}
\examples{
 library(spatstat.random)
 library(spatstat.geom)
 X <- rpoispp(100)
 marks(X) <- data.frame(
 t1 = runif(npoints(X),1,10),
 t2 = runif(npoints(X),1,10),
 t3 = runif(npoints(X),1,10),
 t4 = runif(npoints(X),1,10),
 t5 = runif(npoints(X),1,10))
 lfmcorr(X,  ftype = "stoyan", method = "density")
}
\references{
Eckardt, M., Mateu, J., & Moradi, M. (2024). Function‐Valued Marked Spatial Point Processes on Linear Networks: Application to Urban Cycling Profiles. Stat, 13(4), e70013.

Eckardt, M., & Moradi, M. (2025). Local indicators of mark association for marked spatial point processes.
}
\seealso{
\code{\link[markstat]{mcorr.ppp}}, \code{\link[markstat]{mcorr.lpp}}, \code{\link[markstat]{fmcorr}}.
}
\author{
Mehdi Moradi \email{m2.moradi@yahoo.com} and Matthias Eckardt
}
