% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/General.R
\name{dimensions}
\alias{dimensions}
\alias{calcGeomPar}
\alias{calcIntDim}
\alias{calcAmbDim}
\alias{calcTanDim}
\title{Dimensions in this package}
\usage{
calcGeomPar(mfd, dimAmbient, dimIntrinsic, dimTangent)

calcIntDim(mfd, geomPar, dimAmbient, dimTangent)

calcAmbDim(mfd, geomPar, dimIntrinsic, dimTangent)

calcTanDim(mfd, geomPar, dimAmbient, dimIntrinsic)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{dimAmbient}{Dimension of the ambient space.}

\item{dimIntrinsic}{Intrinsic dimension of the manifold.}

\item{dimTangent}{The length of a tangent vector}

\item{geomPar}{The geometric parameter (e.g., SO(*))}
}
\value{
A scalar value for the geometric parameter

A scalar value for the intrinsic dimension

A scalar value for the ambient dimension

A scalar value for the number of components in the (implementation of the) tangent vector
}
\description{
`calcGeomPar` calculates geometric parameter.
`calcIntDim` calculates the intrinsic dimensions.
`calcAmbDim` calculates the ambient dimensions.
`calcTanDim` calculates the number of tuples used to represent a tangent vector.
}
