# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Symmetrize matrix
#'
#'  Given an input matrix, symmetrize by taking average of lower and upper triangular components as \eqn{A + A^\top}.
#'
#' @param A square matrix
#' @return symmetrized version of \code{A}
#' @export
symmetrize <- function(A) {
    .Call(`_ksm_symmetrize`, A)
}

#' Log of sum with precision
#' @param x vector of log components to add
#' @return double with the log sum of elements
#' @keywords internal
#' @export
sumlog <- function(x) {
    .Call(`_ksm_sumlog`, x)
}

#' Log of mean with precision
#'
#' @keywords internal
#' @param x vector of log components to add
#' @return double with the log mean of elements
meanlog <- function(x) {
    .Call(`_ksm_meanlog`, x)
}

#' Signed sum with precision
#'
#' Given a vector of signs and log arguments,
#' return their sum with precision avoiding
#' numerical underflow assuming that the sum is strictly positive.
#' @keywords internal
#' @param x vector of log components
#' @param sgn sign of the operator
#' @return log sum of elements
#' @export
sumsignedlog <- function(x, sgn) {
    .Call(`_ksm_sumsignedlog`, x, sgn)
}

#' Rotation matrix for 2 dimensional problems
#'
#' @param par double for angle in \eqn{[0,2\pi).}
#' @return a 2 by 2 rotation matrix
#' @export
#' @keywords internal
rotation2d <- function(par) {
    .Call(`_ksm_rotation2d`, par)
}

#' Rotation matrix for 3 dimensional problems
#'
#' @param par vector of length 3 containing elements \eqn{\phi \in [0, 2*\pi)}, \eqn{\theta \in [0, \pi]} and \eqn{\psi \in [0, 2\pi)}, in that order.
#' @return a 3 by 3 rotation matrix
#' @export
#' @keywords internal
rotation3d <- function(par) {
    .Call(`_ksm_rotation3d`, par)
}

#' Rotation matrix with scaling for Monte Carlo integration
#'
#' @param ang vector of length 1 containing  \eqn{\theta \in [0, 2\pi]} for
#' \eqn{d=2}, or of 3 containing elements \eqn{\phi \in [0, 2*\pi)}, \eqn{\theta \in [0, \pi]} and \eqn{\psi \in [0, 2\pi)} for \eqn{d=3}.
#' @param scale vector of length 2 (\eqn{d=2}) or 3 (\eqn{d=3}), strictly positive
#' @return a 2 by 2, or 3 by 3 scaling matrix, depending on inputs
#' @keywords internal
#' @export
rotation_scaling <- function(ang, scale) {
    .Call(`_ksm_rotation_scaling`, ang, scale)
}

#' Multivariate gamma function
#'
#' Given a vector of points \code{x} and an order \code{p}, compute the multivariate gamma function. The function is defined as
#' \deqn{\gamma_p(x) = \pi^{p(p-1)/4}\prod_{i=1}^p \Gamma\{x + (1-i)/2\}.}
#'
#' @param x [vector] of points at which to evaluate the function
#' @param p [int] dimension of the multivariate gamma function, strictly positive.
#' @param log [logical] if \code{TRUE}, returns the log multivariate gamma function.
#' @export
#' @return a matrix with one column of the same length as \code{x}
mgamma <- function(x, p, log = FALSE) {
    .Call(`_ksm_mgamma`, x, p, log)
}

lmgamma <- function(x, p) {
    .Call(`_ksm_lmgamma`, x, p)
}

#' Density of Wishart random matrix
#'
#' @param x array of dimension \code{d} by \code{d} by \code{n}
#' @param S symmetric positive definite matrix of dimension \code{d} by \code{d}
#' @param df degrees of freedom
#' @param log logical; if \code{TRUE}, returns the log density
#' @return a vector of length \code{n} containing the log-density of the Wishart.
#' @export
dWishart <- function(x, df, S, log = FALSE) {
    .Call(`_ksm_dWishart`, x, df, S, log)
}

#' Density of inverse Wishart random matrix
#'
#' @param x array of dimension \code{d} by \code{d} by \code{n}
#' @param S symmetric positive definite matrix of dimension \code{d} by \code{d}
#' @param df degrees of freedom
#' @param log logical; if \code{TRUE}, returns the log density
#' @return a vector of length \code{n} containing the log-density of the inverse Wishart.
#' @export
dinvWishart <- function(x, df, S, log = FALSE) {
    .Call(`_ksm_dinvWishart`, x, df, S, log)
}

dWishart_mat <- function(x, df, S, log = FALSE) {
    .Call(`_ksm_dWishart_mat`, x, df, S, log)
}

#' Random matrix generation from Wishart distribution
#'
#' @param n [integer] sample size
#' @param df [double] degrees of freedom, positive
#' @param S [matrix] a \code{d} by \code{d} positive definite scale matrix
#' @return an array of dimension \code{d} by \code{d} by \code{n} containing the samples
#' @export
rWishart <- function(n, df, S) {
    .Call(`_ksm_rWishart`, n, df, S)
}

#' Random matrix generation from the inverse Wishart distribution
#'
#' @param n [integer] sample size
#' @param df [double] degrees of freedom, positive
#' @param S [matrix] a \code{d} by \code{d} positive definite scale matrix
#' @return an array of dimension \code{d} by \code{d} by \code{n} containing the samples
#' @export
rinvWishart <- function(n, df, S) {
    .Call(`_ksm_rinvWishart`, n, df, S)
}

#' Symmetric matrix-variate normal density
#'
#' @param x [cube] array of dimension \code{d} by \code{d} by \code{n}
#' @param M [matrix] location matrix, positive definite
#' @param b [numeric] scale parameter, strictly positive
#' @param log [logical] if \code{TRUE} (default), returns the log density
#' @return a vector of length \code{n}
#' @export
dsmnorm <- function(x, b, M, log = TRUE) {
    .Call(`_ksm_dsmnorm`, x, b, M, log)
}

dsmnorm_mat <- function(x, b, M, log = TRUE) {
    .Call(`_ksm_dsmnorm_mat`, x, b, M, log)
}

#' Symmetric matrix-variate lognormal density
#'
#' Density of the lognormal matrix-variate density, defined through the matrix logarithm, with the Jacobian resulting from the transformation
#' @param x [cube] array of dimension \code{d} by \code{d} by \code{n}
#' @param M [matrix] location matrix, positive definite
#' @param b [numeric] scale parameter, strictly positive
#' @param log [logical] if \code{TRUE} (default), returns the log density
#' @return a vector of length \code{n}
#' @export
dsmlnorm <- function(x, b, M, log = TRUE) {
    .Call(`_ksm_dsmlnorm`, x, b, M, log)
}

#' Matrix beta type II density function
#'
#' Given a random matrix \code{x}, compute the density
#' for arguments \code{shape1} and \code{shape2}
#' @param x cube of dimension \code{d} by \code{d} by \code{n} containing the random matrix samples
#' @param shape1 positive shape parameter, strictly larger than \eqn{(d-1)/2}.
#' @param shape2 positive shape parameter, strictly larger than \eqn{(d-1)/2}.
#' @param log [logical] if \code{TRUE} (default), returns the log density.
#' @return a vector of length \code{n}
#' @export
dmbeta2 <- function(x, shape1, shape2, log = TRUE) {
    .Call(`_ksm_dmbeta2`, x, shape1, shape2, log)
}

#' Random matrix generation from matrix beta type II distribution
#'
#' This function only supports the case of diagonal matrices
#' @param n sample size
#' @param d dimension of the matrix
#' @param shape1 positive shape parameter, strictly larger than \eqn{(d-1)/2}.
#' @param shape2 positive shape parameter, strictly larger than \eqn{(d-1)/2}.
#' @return a cube of dimension \code{d} by \code{d} by \code{n}
#' @export
rmbeta2 <- function(n, d, shape1, shape2) {
    .Call(`_ksm_rmbeta2`, n, d, shape1, shape2)
}

#' Solver for Riccati equation
#'
#' Given two matrices \code{M} and \code{S}, solve Riccati equation by iterative updating to find the solution \eqn{\mathbf{R}}, where the latter satisfies
#' \deqn{\mathbf{R}=\mathbf{M}\mathbf{R}\mathbf{M}^\top + \mathbf{S}}
#' until convergence (i.e., when the Frobenius norm is less than \code{tol}, or the maximum number of iterations \code{maxiter} is reached.
#' @param M matrix
#' @param S matrix
#' @param tol double for tolerance
#' @param maxiter integer, the maximum number of iterations
#' @export
#' @return a list containing
#' \itemize{
#' \item \code{solution} matrix solution to Riccati's equation
#' \item \code{error} numerical error
#' \item \code{niter} number of iteration
#' \item \code{convergence} bool indicating convergence (\code{TRUE}) if \code{niter < maxiter}
#' }
Riccati <- function(M, S, tol = 1e-8, maxiter = 1e4L) {
    .Call(`_ksm_solvericcati`, M, S, tol, maxiter)
}

dsmlnorm_mat <- function(x, matlog_x, b, M, matlog_M, log = TRUE) {
    .Call(`_ksm_dsmlnorm_mat`, x, matlog_x, b, M, matlog_M, log)
}

#' Likelihood cross validation criterion for symmetric matrix lognormal kernel
#'
#' Given a cube \code{x} and a bandwidth \code{b}, compute
#' the leave-one-out cross validation criterion by taking out a slice
#' and evaluating the kernel at the holdout value.
#' @export
#' @inheritParams dsmlnorm
#' @return the value of the log objective function
lcv_kern_smlnorm <- function(x, b) {
    .Call(`_ksm_lcvkernsmlnorm`, x, b)
}

#' Likelihood cross validation criterion for symmetric matrix normal kernel
#'
#' Given a cube \code{x} and a bandwidth \code{b}, compute
#' the leave-one-out cross validation criterion by taking out a slice
#' and evaluating the kernel at the holdout value.
#' @export
#' @inheritParams dsmlnorm
#' @return the value of the log objective function
lcv_kern_smnorm <- function(x, b) {
    .Call(`_ksm_lcvkernsmnorm`, x, b)
}

#' Likelihood cross validation criterion for Wishart kernel
#'
#' Given a cube \code{x} and a bandwidth \code{b}, compute
#' the leave-one-out cross validation criterion by taking out a slice
#' and evaluating the kernel at the holdout value.
#'
#' @inheritParams dsmlnorm
#' @export
#' @return the value of the log objective function
lcv_kern_Wishart <- function(x, b) {
    .Call(`_ksm_lcvkernWishart`, x, b)
}

#' Likelihood cross-validation for symmetric positive definite matrix kernels
#'
#' Given a cube of sample observations (consisting of random symmetric positive definite matrices), and a vector of candidate bandwidth parameters \code{b},
#' compute the leave-one-out likelihood cross-validation criterion and
#' return the bandwidth among the choices that minimizes the criterion.
#' @param x array of dimension \code{d} by \code{d} by \code{n}
#' @param b vector of candidate bandwidth, strictly positive
#' @param kernel string indicating the kernel, one of \code{Wishart} or \code{smlnorm}.
#' @importFrom utils tail
#' @import Rcpp
#' @export
#' @return a list with arguments
#' \itemize{
#' \item \code{lcv} vector of likelihood cross validation criterion
#' \item \code{b} vector of candidate bandwidth
#' \item \code{bandwidth} optimal bandwidth among candidates
#' \item \code{kernel} string indicating the choice of kernel function
#'}
lcv_kdens_symmat <- function(x, b, kernel = "Wishart") {
    .Call(`_ksm_lcvsymmat`, x, b, kernel)
}

#' Wishart kernel density
#'
#' Given a sample of \code{m} points \code{xs} from an original sample
#' and a set of \code{n} new sample matrices \code{x} at which to evaluate the Wishart kernel, return the density with bandwidth parameter \code{b}.
#'
#' @param x cube of size \code{d} by \code{d} by \code{n} of points at which to evaluate the density
#' @param xs cube of size \code{d} by \code{d} by \code{m} of sample matrices which are used to construct the kernel
#' @param b positive double giving the bandwidth parameter
#' @param log bool; if \code{TRUE}, return the log density
#' @return a vector of length \code{n} containing the (log) density of the sample \code{x}
#' @export
kdens_Wishart <- function(x, xs, b, log = TRUE) {
    .Call(`_ksm_kdensWishart`, x, xs, b, log)
}

#' Symmetric matrix log-normal kernel density
#'
#' Given a sample of \code{m} points \code{xs} from an original sample
#' and a set of \code{n} new sample matrices \code{x} at which to evaluate the symmetric matrix normal log kernel, return the density with bandwidth parameter \code{b}.
#'
#' @param x cube of size \code{d} by \code{d} by \code{n} of points at which to evaluate the density
#' @param xs cube of size \code{d} by \code{d} by \code{m} of sample matrices which are used to construct the kernel
#' @param b positive double giving the bandwidth parameter
#' @param log bool; if \code{TRUE}, return the log density
#' @return a vector of length \code{n} containing the (log) density of the sample \code{x}
#' @export
kdens_smlnorm <- function(x, xs, b, log = TRUE) {
    .Call(`_ksm_kdenssmlnorm`, x, xs, b, log)
}

#' Symmetric matrix normal kernel density
#'
#' Given a sample of \code{m} points \code{xs} from an original sample
#' and a set of \code{n} new sample matrices \code{x} at which to evaluate the symmetric matrix normal kernel, return the density with bandwidth parameter \code{b}. Note that this kernel suffers from boundary spillover.
#'
#' @param x cube of size \code{d} by \code{d} by \code{n} of points at which to evaluate the density
#' @param xs cube of size \code{d} by \code{d} by \code{m} of sample matrices which are used to construct the kernel
#' @param b positive double giving the bandwidth parameter
#' @param log bool; if \code{TRUE}, return the log density
#' @return a vector of length \code{n} containing the (log) density of the sample \code{x}
#' @export
kdens_smnorm <- function(x, xs, b, log = TRUE) {
    .Call(`_ksm_kdenssmnorm`, x, xs, b, log)
}

#' Kernel density estimators for symmetric matrices
#'
#' Given a sample of \code{m} points \code{xs} from an original sample
#' and a set of \code{n} new sample symmetric positive definite matrices \code{x} at which to evaluate the kernel, return the density with bandwidth parameter \code{b}.
#'
#' @param x cube of size \code{d} by \code{d} by \code{n} of points at which to evaluate the density
#' @param xs cube of size \code{d} by \code{d} by \code{m} of sample matrices which are used to construct the kernel
#' @param b positive double giving the bandwidth parameter
#' @param kernel string, one of \code{Wishart}, \code{smnorm} or \code{smlnorm}.
#' @param log bool; if \code{TRUE}, return the log density
#' @return a vector of length \code{n} containing the (log) density of the sample \code{x}
#' @export
kdens_symmat <- function(x, xs, kernel = "Wishart", b = 1, log = TRUE) {
    .Call(`_ksm_kdens_symmat`, x, xs, kernel, b, log)
}

#' Least square cross validation criterion for Wishart kernel
#'
#' Finite sample h-block leave-one-out approximation to the least
#' square criterion, omitting constant term.
#' @inheritParams lcv_kern_Wishart
#' @export
#' @param h separation vector; only pairs that are \eqn{|i-j| \leq h} apart are considered
#' @return a vector of length two containing the log of the summands
lscv_kern_Wishart <- function(x, b, h = 1L) {
    .Call(`_ksm_lscvkernwishart`, x, b, h)
}

#' Least square cross validation criterion for log symmetric matrix normal kernel
#'
#' Finite sample h-block leave-one-out approximation to the least
#' square criterion, omitting constant term. Only pairs that are \eqn{|i-j| \leq h} apart are considered.
#'
#' @inheritParams lcv_kern_Wishart
#' @export
#' @param h [int] integer indicating the separation lag
#' @return a vector of length two containing the log of the summands
lscv_kern_smlnorm <- function(x, b, h = 1L) {
    .Call(`_ksm_lscvkernsmlnorm`, x, b, h)
}

#' Random vector generation from the multivariate normal distribution
#'
#' Sampler derived using the eigendecomposition of the covariance
#' matrix \code{vcov}.
#'
#' @param n sample size
#' @param mean mean vector of length \code{d}
#' @param vcov a square positive definite covariance matrix, of the same dimension as \code{mean}.
#' @export
#' @return an \code{n} by \code{d} matrix of samples
#' @examples
#' rmnorm(n = 10, mean = c(0, 2), vcov = diag(2))
rmnorm <- function(n, mean, vcov) {
    .Call(`_ksm_rmnorm`, n, mean, vcov)
}

#' Target densities for simulation study
#' @param x cube of dimension \code{d} by \code{d} by \code{n} containing the sample matrices
#' @param model integer between 1 and 6 indicating the simulation scenario
#' @param d dimension of the problem, an integer between 2 and 10
#' @export
#' @return a vector of length \code{n} containing the density
#' @keywords internal
simu_fdens <- function(x, model, d) {
    .Call(`_ksm_fdens`, x, model, d)
}

#' Target densities for simulation study
#' @param n sample size
#' @param model integer between 1 and 6 indicating the simulation scenario
#' @param d dimension of the matrix, an integer between 2 and 10
#' @export
#' @return a cube of dimension \code{d} by \code{d} by \code{n} containing the sample matrices
#' @keywords internal
simu_rdens <- function(n, model, d) {
    .Call(`_ksm_rdens`, n, model, d)
}

#' Integrated squared error via Monte Carlo
#'
#' Given a target density and a kernel estimator, evaluate the
#' integrated squared error by Monte Carlo integration by simulating
#' from uniform variates on the hypercube.
#' @param x a cube of dimension \code{d} by \code{d} by \code{n} containing the sample matrices which define the kernel matrix estimator
#' @param b positive double, bandwidth parameter
#' @param model integer between 1 and 6 indicating the simulation scenario
#' @param B number of Monte Carlo replications, default to 10K
#' @param delta double less than 1; the integrals on \eqn{[0, \infty)} are truncated to \eqn{[\delta, 1/\delta]}.
#' @export
#' @return a vector of length 2 containing the mean and the standard deviation of the estimator.
#' @keywords internal
simu_ise_montecarlo <- function(x, b, kernel, model, B = 10000L, delta = 0.001) {
    .Call(`_ksm_ise_montecarlo`, x, b, kernel, model, B, delta)
}

#' Kullback-Leibler divergence via Monte Carlo
#'
#' Given a target density and a kernel estimator, evaluate the
#' Kullback-Leibler divergence by Monte Carlo integration by simulating draws from the corresponding model.
#' @param x a cube of dimension \code{d} by \code{d} by \code{n} containing the sample matrices which define the kernel matrix estimator
#' @param b positive double, bandwidth parameter
#' @param model integer between 1 and 6 indicating the simulation scenario
#' @param B number of Monte Carlo replications, default to 10K
#' @export
#' @return a vector of length 2 containing the mean and the standard deviation of the estimator.
#' @keywords internal
simu_kldiv <- function(x, b, kernel, model, B = 10000L, nrep = 10L) {
    .Call(`_ksm_kldiv_montecarlo`, x, b, kernel, model, B, nrep)
}

