% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svytools.R
\name{pf_sv_test}
\alias{pf_sv_test}
\title{Test whether sampling weights are needed}
\usage{
pf_sv_test(
  model,
  data = NULL,
  weights,
  sims = 1000,
  digits = getOption("jtools-digits", default = 3)
)
}
\arguments{
\item{model}{The fitted model, without weights}

\item{data}{The data frame with the data fed to the fitted model and the
weights}

\item{weights}{The name of the weights column in \code{model}'s data frame
or a vector of weights equal in length to the number of observations
included in \code{model}.}

\item{sims}{The number of bootstrap simulations to use in estimating the
variance of the residual correlation. Default is 1000, but for publications
or when computing power/time is sufficient, a higher number is better.}

\item{digits}{An integer specifying the number of digits past the decimal to
report in the output. Default is 3. You can change the default number of
digits for all jtools functions with
\code{options("jtools-digits" = digits)} where digits is the desired number.}
}
\description{
Use the test proposed in Pfeffermann and Sverchkov (1999) to check whether
a regression model is specified correctly without weights.
}
\details{
This is a test described by Pfeffermann and Sverchkov (1999) that is
designed to help analysts decide whether they need to use sample weights
in their regressions to avoid biased parameter estimation.

It first checks the correlation of the residuals of the model with the
weights. It then uses bootstrapping to estimate the variance of the
correlation, ending with a t-test of whether the correlation differs from
zero. This is done for the squared residuals and cubed residuals as well.
If anyone of them are statistically significant (at whatever level you
feel appropriate), it is best to do a weighted regression. Note that in
large samples, a very small correlation may have a low p-value without a
large bias in the unweighted regression.
}
\examples{

# Note: This is a contrived example to show how the function works,
# not a case with actual sammpling weights from a survey vendor
if (requireNamespace("boot")) {
  states <- as.data.frame(state.x77)
  set.seed(100)
  states$wts <- runif(50, 0, 3)
  fit <- lm(Murder ~ Illiteracy + Frost, data = states)
  pf_sv_test(model = fit, data = states, weights = wts, sims = 100)
}

}
\references{
Pfeffermann, D., & Sverchkov, M. (1999). Parametric and semi-parametric
estimation of regression models fitted to survey data.
\emph{Sankhya: The Indian Journal of Statistics}, \emph{61}. 166-186.
}
\seealso{
Other survey tools: 
\code{\link{svycor}()},
\code{\link{svysd}()},
\code{\link{weights_tests}()},
\code{\link{wgttest}()}
}
\concept{survey tools}
