% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweep_final_nD.R
\name{sweep.final_nD}
\alias{sweep.final_nD}
\title{Sweep the space of n parameters at the final state of a system}
\usage{
sweep.final_nD(
  workdir,
  sweep_master_file,
  sweep_dir_to_complete = NULL,
  export.data_as_csv_xlsx = FALSE,
  isobxr_master_file = "0_ISOBXR_MASTER",
  save_outputs = FALSE
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{0_ISOBXR_MASTER.xlsx}} master file, \cr
of the dynamic sweep master file (e.g., \strong{\emph{0_EXPLO_DYN_MASTER.xlsx}}) \cr
and where output files will be stored if saved by user. \cr
(character string)}

\item{sweep_master_file}{Name of \strong{\emph{sweep.final_nD excel master file}}.
(without file "xlsx" extension).}

\item{sweep_dir_to_complete}{Name of directory of previously halted sweep.final_nD
run that the user wishes to continue. Starts with "4_FINnD". \cr
Default is NULL.}

\item{export.data_as_csv_xlsx}{If TRUE, exports chunk sweep result data as csv and xlsx fo full
to chunk digest directory. \cr
Default is FALSE.}

\item{isobxr_master_file}{Name of \strong{\emph{isobxr excel master file}}. \cr
Default is "0_ISOBXR_MASTER".}

\item{save_outputs}{If TRUE, saves all run outputs to local working directory (workdir). \cr
By default, run outputs are stored in a temporary directory and erased if not saved.
Default is FALSE.}
}
\value{
Delta values and box sizes at final state of the system, in the n-dimensions space of parameters.
sweep.final_nD outputs are saved to workdir if save_outputs = TRUE.
}
\description{
A function to assess the influence of n parameters (varying
over a range of values) on the final state of a system.
}
\section{sweep.final_nD outputs}{

\enumerate{
\item \strong{digest sweep.final_nD outputs} full sweep.final_nD outputs are stored in a digest directory directly in workdir:
\enumerate{
\item \strong{isobxr master file archive} as xlsx
\item \strong{global chunk_log} as csv
\item \strong{global chunk_log} as rds
\item \strong{sweep.final_nD master file archive} as xlsx
\item \strong{sweep.final_nD merged chunks LOG excerpt} as csv
\item \strong{sweep.final_nD merged param_space}, current progress, as rds (space of swept parameters)
\item \strong{sweep.final_nD merged results}, current progress, as rds
\enumerate{
\item data frame containing delta and size at final state across whole n-dimensions space of parameters
\item \strong{sweep.final_nD param_space} as planned, as rds
\item \strong{sweep.final_nD sweep_default} data frame of default run conditions, as rds
\item \strong{sweep.final_nD sweep progress plot} as pdf, follows merging of chunks
}
}
\item \strong{chunks sweep.final_nD outputs} chunk directories are edited in case total number.
 of runs exceeds chunk size defined in sweep.final_nD master file. They are removed after full sweep.
}
}

