% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_scenario.R
\name{sim.scenario}
\alias{sim.scenario}
\title{Simulate a scenario}
\usage{
sim.scenario(
  workdir,
  SERIES_ID,
  scenario_master_file,
  isobxr_master_file = "0_ISOBXR_MASTER",
  plot.hidden_boxes = NULL,
  plot.time_unit = NULL,
  export.single_run_digests = FALSE,
  export.data_as_csv_xlsx = FALSE,
  show.delta_plot = TRUE,
  save_outputs = FALSE,
  inspect_inputs = TRUE
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{isobxr excel master file}}
and where output files will be stored if exported by user.}

\item{SERIES_ID}{Name of the series the scenario run belongs to.
It determines the folder in which the output files will be stored inside workdir.}

\item{scenario_master_file}{Name of \strong{\emph{scenario excel master file}}.}

\item{isobxr_master_file}{Name of \strong{\emph{isobxr excel master file}}. \cr
Default is "0_ISOBXR_MASTER".}

\item{plot.hidden_boxes}{list of box names (BOX_ID) to hide in scenario plot.}

\item{plot.time_unit}{Time unit to use on plot if different from native time unit. \cr
Character string, to be selected among the following:\cr
\emph{micros, ms, s, min, h, d, wk, mo, yr, kyr, Myr, Gyr}\cr
Default is NULL.}

\item{export.single_run_digests}{If TRUE, exports full digest of each single run
of the scenario.
Default is FALSE.}

\item{export.data_as_csv_xlsx}{If TRUE, exports full scenario result data as csv and xlsx fo full
to scenario digest directory. \cr
Default is FALSE.}

\item{show.delta_plot}{If TRUE, prints delta and size time evolution plots in R. \cr
Default is TRUE.}

\item{save_outputs}{If TRUE, saves all run outputs to local working directory (workdir). \cr
By default, run outputs are stored in a temporary directory and erased if not saved. \cr
Default is FALSE.}

\item{inspect_inputs}{If TRUE, inspects and proof checks format of input taken from
\strong{\emph{isobxr excel master file}}. \cr
(Inspection run by \code{\link{read.isobxr_master}} function.) \cr
Default is TRUE.}
}
\value{
Delta values and box sizes as a function of time. \cr
sim.scenario outputs are saved to workdir if save_outputs = TRUE.
}
\description{
A function to compose an isotope box model scenario,
defined by a series of successive runs, \cr
each run inheriting from the final state conditions of the previous run. \cr
It is possible to force parameters at each run, namely:
\enumerate{
\item \strong{fluxes} \cr
(overwriting all or a subset of fluxes defined in \emph{0_ISOBXR_MASTER.xlsx} master file)
\item \strong{isotope fractionation coefficients} \cr
(overwriting all or a subset of coefficients defined in \emph{0_ISOBXR_MASTER.xlsx} master file)
\item \strong{box sizes} \cr
(overwriting all or a subset of box sizes defined in \emph{0_ISOBXR_MASTER.xlsx} master file)
\item \strong{rayleigh isotope distillation}
\item \strong{isotope composition of a source box at initial state}
}
}
\section{sim.scenario outputs consist of}{

\enumerate{
\item \strong{single run results} in SERIES directory: all single runs results as rds files
\item \strong{scenario digest} in scenario DIGEST directory (SERIES/DIGEST):
\enumerate{
\item \strong{isobxr master file archive} as xlsx
\item \strong{scenario master file archive} as xlsx
\item \strong{plot of delta and size vs. time} as pdf
\item \strong{scenario results data set} as rds, containing:
\enumerate{
\item \strong{delta_vs_t} data frame of delta as a function of time
\item \strong{size_vs_t} data frame of box sizes as a function of time
\item \strong{scenario_master} list containing all inputs from scenario master file
\item \strong{scenario_log} data frame of scenario specific LOG excerpt
\item \strong{isobxr_master} list containing all inputs from isobxr master file
\item \strong{paths} list of scenario specific paths
}
}
}
}

\examples{
\dontrun{
sim.scenario(workdir = "/Users/username/Documents/1_ABC_tutorial",
             SERIES_ID =  "1_source_change",
             scenario_master_file = "0_SCENARIO_source_change",
             isobxr_master_file = "0_ISOBXR_MASTER")
}
}
