% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_final_nD_master.R
\name{read.final_nD_master}
\alias{read.final_nD_master}
\title{Read and inspect sweep.final_nD master files}
\usage{
read.final_nD_master(workdir, final_nD_master_file, isobxr_master_file)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{isobxr excel master file}}
and where output files will be stored if exported by user.
(character string)}

\item{final_nD_master_file}{Name of \strong{\emph{sweep.final_nD excel master file}}.
(without file "xlsx" extension).}

\item{isobxr_master_file}{Name of \strong{\emph{isobxr excel master file}}.
(without file "xlsx" extension).
Default is "0_ISOBXR_MASTER".}
}
\value{
List of formatted sweep.final_nD master inputs
}
\description{
A function to read and inspect the sweep.final_nD master files
and obtain a master formatted list.
}
\details{
List contains:
\enumerate{
\item \strong{param_space} data frame of shuffled all combinations of all parameters values.
\item \strong{sweep.DEFAULT} data frame of default run conditions \cr
(flux and coeff lists, t_max, chunk size)
\item \strong{sweep_lists_ids} list of names of swept parameters
}
}
\examples{
read.final_nD_master(workdir = "/Users/username/Documents/1_ABC_tutorial",
                     final_nD_master_file = "0_SWEEP_FINnD_demo",
                     isobxr_master_file = "0_ISOBXR_MASTER")

}
