% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scenario.R
\name{plot_scenario}
\alias{plot_scenario}
\title{plot sim.scenario outputs}
\usage{
plot_scenario(
  workdir,
  scenario_dir_name,
  shown_runs = NULL,
  time_unit = NULL,
  hidden_boxes = NULL,
  return_as_print = TRUE,
  show.facets = FALSE,
  show.run_separations = TRUE,
  observations_file = NULL,
  observations_groups = NULL
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{isobxr excel master file}}
and where output files will be stored if exported by user.
(character string)}

\item{scenario_dir_name}{name of sim.scenario SERIES directory (starts with 3_SCEN)}

\item{shown_runs}{Vector of successive run numbers (RUN_n) to be displayed (e.g., 1:5). \cr
Default is run 2 to last run (hides initial relaxation run)}

\item{time_unit}{Time unit to use on plot if different from native time unit. \cr
Character string, to be selected among the following: \cr
\emph{micros, ms, s, min, h, d, wk, mo, yr, kyr, Myr, Gyr} \cr
Default is NULL.}

\item{hidden_boxes}{List of boxes to hide from plots, as a vector of character strings. \cr
For instance c("SOURCE", "SINK").}

\item{return_as_print}{If TRUE, prints delta and size vs. time plots in a single page figure on R. \cr
If FALSE, returns separately delta and size vs. time plots as list of two editable R objects.}

\item{show.facets}{If TRUE, shows delta vs. time as faceted by BOX. \cr
Default is FALSE.}

\item{show.run_separations}{If TRUE, shows limits between subruns. \cr
Default is TRUE.}

\item{observations_file}{Name of the csv file containing observations (without csv extension). \cr
Observation csv file should contain the following columns: \cr
\enumerate{
\item \strong{GROUP}: observation subset group label if relevant
\item \strong{BOX_ID}: BOX ID (e.g., A, OCEAN...) as defined in isobxr master file.
\item \strong{delta.def} definition of delta value, e.g., d18O
\item \strong{obs.delta} average observed delta numerical value
\item \strong{obs.CI} confidence interval of delta value
\item \strong{obs.CI.def} definition of confidence interval, e.g., 95% ci
\item \strong{obs.counts} number of observations corresponding to average delta
\item \strong{Time} time of observation in scenario timeline, in display time units
}
Default is NULL.}

\item{observations_groups}{vector of observations groups to include in plot, \cr
from GROUP column in observation csv file. \cr
Default is NULL.}
}
\value{
A set of plots showing the evolution of delta and sizes with time.
}
\description{
A function to plot delta and size vs time from the sim.scenario runs and to include observations along simulations.
}
