% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/property.R
\name{forall}
\alias{forall}
\title{Hedgehog property test}
\usage{
forall(generator, property, tests = getOption("hedgehog.tests", 100),
  size.limit = getOption("hedgehog.size", 50),
  shrink.limit = getOption("hedgehog.shrinks", 100),
  discard.limit = getOption("hedgehog.discards", 100),
  curry = identical(class(generator), "list"))
}
\arguments{
\item{generator}{a generator or list of generators
(potentially nested) to use for value testing.}

\item{property}{a function which takes a value from
from the generator and tests some predicated against
it.}

\item{tests}{the number of tests to run}

\item{size.limit}{the max size used for the generators}

\item{shrink.limit}{the maximum number of shrinks to
run when shrinking a value to find the smallest
counterexample.}

\item{discard.limit}{the maximum number of discards to
permit when running the property.}

\item{curry}{whether to curry the arguments passed
to the property, and use do.call to use the list
generated as individual arguments.
When curry is on, the function arity should be the
same as the length of the generated list.
Defaults to \code{T} if the input is a list.}
}
\description{
Check a property holds for all generated values.
}
\details{
The generator used can be defined flexibly, in that
one can pass in a list of generators, or even nest
generators and constant values deeply into the gen
argument and the whole construct will be treated
as a generator.
}
\examples{
test_that( "Reverse and concatenate symmetry",
  forall( list( as = gen.c( gen.element(1:100) )
              , bs = gen.c( gen.element(1:100) ))
        , function( as, bs )
            expect_identical ( rev(c(as, bs)), c(rev(bs), rev(as)))
  )
)

# False example showing minimum shrink:
\dontrun{
test_that( "Reverse is identity",
  forall ( gen.c( gen.element(1:100)), function(x) { expect_identical ( rev(x), c(x) ) } )
)
}
# Falsifiable after 1 tests, and 5 shrinks
# Predicate is falsifiable

# Counterexample:
# [1] 1 2

}
