% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTD-plot.R
\name{plot.MTD}
\alias{plot.MTD}
\title{Plot method for MTD objects}
\usage{
\method{plot}{MTD}(x, type, main, ylim, col = "gray70", border = NA, pj_index = 1, ...)
}
\arguments{
\item{x}{An object of class \code{"MTD"}.}

\item{type}{If \code{type} is missing, all plots are shown sequentially
(press Enter to proceed). Else, \code{type} is a character string indicating
what to plot: \code{"oscillation"}, \code{"lambdas"} or \code{"pj"}.}

\item{main}{Optional main title. When \code{type} is missing, panel-specific
defaults are used and \code{main} is ignored.}

\item{ylim}{Optional y-axis limits. When \code{type} is missing, panel-specific
defaults are used and \code{ylim} is ignored.}

\item{col}{Bar fill color (passed to \code{barplot}). Defaults to \code{"gray70"}.}

\item{border}{Bar border color (passed to \code{barplot}). Defaults to \code{NA}.}

\item{pj_index}{Integer index of \code{pj(x)} to plot when \code{type = "pj"}
(default \code{1}).}

\item{...}{Further graphical parameters: passed to \code{barplot()} when
\code{type \%in\% c("oscillation","lambdas")} and to \code{plot.igraph()}
when \code{type = "pj"}. Ignored when \code{type} is missing.}
}
\value{
If \code{type} is \code{"oscillation"} or \code{"lambdas"}, invisibly returns the numeric
vector that was plotted. If \code{type = "pj"}, invisibly returns the selected transition
matrix. If \code{type} is missing, invisibly returns a list with components
\code{oscillation} and \code{lambdas}.
}
\description{
Produces plots for an \code{MTD} object. By default, it shows the following
sequence of plots: (i) barplot of oscillations by relevant lag,
(ii) barplot of mixture weights \eqn{\lambda_j} (including \code{lam0} if \code{> 0})
and (iii) graphs of \code{pj}, one graph for each lag in \code{Lambda}. When
\code{type} is specified, only the requested plot is drawn.
}
\details{
For \code{type = "oscillation"}, the function calls \code{oscillation(x)}
to obtain \eqn{\delta_j = \lambda_j \max_{b,c} d_{TV}(p_j(\cdot|b), p_j(\cdot|c))}
for each lag in \code{Lambda(x)}, and draws a bar plot named by the lags.

For \code{type = "lambdas"}, it plots the mixture weights \eqn{\lambda_j} by lag.
If \code{lam0 > 0}, the weight for the independent component is included and
labeled \code{"0"}.

For \code{type = "pj"}, the function draws the directed, weighted graph of a
transition matrix \code{pj} taken from \code{pj(x)}. Vertices correspond to the
states \code{states(x)}. A directed edge \code{a -> b} carries weight
\code{p_j(b | a)}. Edge widths and edge labels are proportional to the transition
probabilities (labels shown in the plot are rounded to two decimals).
By default, self-loops (\code{a -> a}) are not drawn. The self-loop probability
at a state \code{a} can be inferred as \deqn{1 - \sum_{b: b \ne a} p_j(b \mid a).}
For \code{type = "pj"}, a specific matrix can be selected via \code{pj_index}
(e.g., \code{pj_index = 2} plots \code{pj(x)[[2]]}). In automatic mode (when
\code{type} is missing), graphs for all \code{pj} matrices are shown
sequentially.
}
\examples{
\dontrun{
m <- MTDmodel(Lambda = c(1, 3), A = c(0, 1))

## Automatic mode (press Enter between plots)
plot(m)

## Single plot:
plot(m, type = "oscillation")
plot(m, type = "lambdas")
plot(m, type = "pj", pj_index = 2)
}

}
\seealso{
\code{\link{oscillation}}, \code{\link{lambdas}}, \code{\link{Lambda}}
}
