% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmo_xsax.R
\name{hmo_xsax}
\alias{hmo_xsax}
\title{Motif discovery using xsax}
\usage{
hmo_xsax(a, w, qtd)
}
\arguments{
\item{a}{alphabet size}

\item{w}{word size}

\item{qtd}{number of occurrences to be classified as motifs}
}
\value{
\code{hmo_xsax} object
}
\description{
Motif discovery using xsax \url{doi:10.1007/s10618-007-0064-z}
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_motifs)

#Using sequence example
dataset <- examples_motifs$simple
head(dataset)

# setting up motif discovery method
model <- hmo_xsax(37, 3, 3)

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
