% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_amoc.R
\name{hcp_amoc}
\alias{hcp_amoc}
\title{At most one change (AMOC) method}
\usage{
hcp_amoc()
}
\value{
\code{hcp_amoc} object
}
\description{
Change-point detection method that focus on identify one change point in mean/variance \url{doi:10.1093/biomet/57.1.1}.
It wraps the amoc implementation available in the changepoint library.
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_changepoints)

#Using simple example
dataset <- examples_changepoints$simple
head(dataset)

# setting up change point method
model <- hcp_amoc()

# fitting the model
model <- fit(model, dataset$serie)

# execute the detection method
detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
