% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_emd.R
\name{hanr_emd}
\alias{hanr_emd}
\title{Anomaly detector using EMD}
\usage{
hanr_emd(noise = 0.1, trials = 5)
}
\arguments{
\item{noise}{nosie}

\item{trials}{trials}
}
\value{
\code{hanr_emd} object
}
\description{
Anomaly detection using EMD
The EMD model adjusts to the time series. Observations distant from the model are labeled as anomalies.
It wraps the EMD model presented in the hht library.
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_anomalies)

#Using simple example
dataset <- examples_anomalies$simple
head(dataset)

# setting up time series emd detector
model <- hanr_emd()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
