% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service-perplexity.R
\name{create_completion_perplexity}
\alias{create_completion_perplexity}
\title{Create a chat completion request to the Perplexity API}
\usage{
create_completion_perplexity(
  prompt,
  model = "mistral-7b-instruct",
  api_key = Sys.getenv("PERPLEXITY_API_KEY")
)
}
\arguments{
\item{prompt}{A list containing prompts to be sent in the chat.}

\item{model}{A character string representing the Perplexity model to be used.
Defaults to "mistral-7b-instruct".}

\item{api_key}{The API key for accessing the Perplexity API. Defaults to the
PERPLEXITY_API_KEY environment variable.}
}
\value{
The response from the Perplexity API containing the completion for the chat.
}
\description{
This function sends a series of messages alongside a chosen model to the Perplexity API
to generate a chat completion. It returns the API's generated responses.
}
