% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service-openai_streaming.R
\name{OpenaiStreamParser}
\alias{OpenaiStreamParser}
\title{Stream handler for chat completions}
\description{
Stream handler for chat completions

Stream handler for chat completions
}
\details{
R6 class that allows to handle chat completions chunk by chunk.
It also adds methods to retrieve relevant data. This class DOES NOT make the request.

Because \code{curl::curl_fetch_stream} blocks the R console until the stream finishes,
this class can take a shiny session object to handle communication with JS
without recurring to a \code{shiny::observe} inside a module server.
}
\section{Super class}{
\code{\link[SSEparser:SSEparser]{SSEparser::SSEparser}} -> \code{OpenaiStreamParser}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{shinySession}}{Holds the \code{session} provided at initialization}

\item{\code{user_prompt}}{The \code{user_prompt} provided at initialization,
after being formatted with markdown.}

\item{\code{value}}{The content of the stream. It updates constantly until the stream ends.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OpenaiStreamParser-new}{\code{OpenaiStreamParser$new()}}
\item \href{#method-OpenaiStreamParser-append_parsed_sse}{\code{OpenaiStreamParser$append_parsed_sse()}}
\item \href{#method-OpenaiStreamParser-clone}{\code{OpenaiStreamParser$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="SSEparser" data-topic="SSEparser" data-id="parse_sse"><a href='../../SSEparser/html/SSEparser.html#method-SSEparser-parse_sse'><code>SSEparser::SSEparser$parse_sse()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenaiStreamParser-new"></a>}}
\if{latex}{\out{\hypertarget{method-OpenaiStreamParser-new}{}}}
\subsection{Method \code{new()}}{
Start a StreamHandler. Recommended to be assigned to the \code{stream_handler} name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenaiStreamParser$new(session = NULL, user_prompt = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{The shiny session it will send the message to (optional).}

\item{\code{user_prompt}}{The prompt for the chat completion.
Only to be displayed in an HTML tag containing the prompt. (Optional).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenaiStreamParser-append_parsed_sse"></a>}}
\if{latex}{\out{\hypertarget{method-OpenaiStreamParser-append_parsed_sse}{}}}
\subsection{Method \code{append_parsed_sse()}}{
Overwrites \code{SSEparser$append_parsed_sse()} to be able to send a custom message
to a shiny session, escaping shiny's reactivity.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenaiStreamParser$append_parsed_sse(parsed_event)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parsed_event}}{An already parsed server-sent event to append to the events field.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenaiStreamParser-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OpenaiStreamParser-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenaiStreamParser$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
