% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ga_model}
\alias{ga_model}
\title{Use a model}
\usage{
ga_model(viewId, model, load_libs = TRUE, ...)
}
\arguments{
\item{viewId}{The GA viewId to operate on}

\item{model}{A file location of a model object or a model object
created by \link{ga_model_make}}

\item{load_libs}{Whether to load the library requirements into your namespace}

\item{...}{Other arguments to pass into the model as needed}
}
\description{
Use a model created by \link{ga_model_make}
}
\examples{

# models that come with the package
ga_model_example()
\dontrun{

# your own Google Analytics viewID
my_viewid <- 81416156

# load the model (equivalent to ga_model_load())
decomp_ga <- ga_model_example("decomp_ga.gamr")

# apply model to your data
d1 <- ga_model(my_viewid, model = decomp_ga)

# change default date range to 20 days ago to yesterday
d2 <- ga_model(my_viewid, model = decomp_ga, 
               date_range = c("20daysAgo","yesterday"))


}
}
\seealso{
Other GA modelling functions: 
\code{\link{ga_model_edit}()},
\code{\link{ga_model_example}()},
\code{\link{ga_model_load}()},
\code{\link{ga_model_make}()},
\code{\link{ga_model_save}()},
\code{\link{ga_model_shiny}()},
\code{\link{ga_model_shiny_load}()},
\code{\link{ga_model_shiny_template}()},
\code{\link{ga_model_write}()}
}
\concept{GA modelling functions}
