% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{method_histogram}
\alias{method_histogram}
\title{Bivariate histogram HDR estimator}
\usage{
method_histogram(bins = NULL, smooth = FALSE, nudgex = "none", nudgey = "none")
}
\arguments{
\item{bins}{Number of bins along each axis.
Either a vector of length 2 or a scalar value which is recycled for both dimensions.
Defaults to normal reference rule (Scott, pg 87).}

\item{smooth}{If \code{TRUE}, HDRs are smoothed by the marching squares algorithm.}

\item{nudgex, nudgey}{Horizontal and vertical rules for choosing witness points when \code{smooth == TRUE}.
Accepts character vector: \code{"left"}, \code{"none"}, \code{"right"} (\code{nudgex}) or  \code{"down"}, \code{"none"}, \code{"up"} (\code{nudgey}).}
}
\description{
Function used to specify bivariate histogram density estimator
for \code{get_hdr()} and layer functions (e.g. \code{geom_hdr()}).
}
\details{
For more details on the use and implementation of the \verb{method_*()} functions,
see \code{vignette("method", "ggdensity")}.
}
\examples{
\dontrun{

# Histogram estimators can be useful when data has boundary constraints
set.seed(1)
df <- data.frame(x = rexp(1e3), y = rexp(1e3))

ggplot(df, aes(x, y)) +
  geom_hdr(method = method_histogram()) +
  geom_point(size = 1)

# The resolution of the histogram estimator can be set via `bins`
ggplot(df, aes(x, y)) +
  geom_hdr(method = method_histogram(bins = c(8, 25))) +
  geom_point(size = 1)

# By setting `smooth = TRUE`, we can graphically smooth the "blocky" HDRs
ggplot(df, aes(x, y)) +
  geom_hdr(method = method_histogram(smooth = TRUE)) +
  geom_point(size = 1)

# However, we need to set `nudgex` and `nudgey` to align the HDRs correctly
ggplot(df, aes(x, y)) +
  geom_hdr(method = method_histogram(smooth = TRUE, nudgex = "left", nudgey = "down")) +
  geom_point(size = 1)

# Can also be used with `get_hdr()` for numerical summary of HDRs
res <- get_hdr(df, method = method_histogram())
str(res)
}

}
\references{
Scott, David W. Multivariate Density Estimation (2e), Wiley.
}
