% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{plot_sil}
\alias{plot_sil}
\title{Plots a silhouette read by measuresil()}
\usage{
plot_sil(
  sil,
  flip = FALSE,
  add = FALSE,
  expansion = 1,
  xoffset = 0,
  yoffset = 0,
  alpha = 1,
  col = "grey",
  border = "darkgrey",
  scale = 1,
  xlab = "",
  ylab = "",
  ...
)
}
\arguments{
\item{sil}{A data frame that is the output of measuresil(..., return="all"), containing the center and the diameter of the silhouette at each value for x.}

\item{flip}{Logical indicating whether to flip axes (needed if measuresil() was performed using align="v", defaults to FALSE.}

\item{add}{Logical indicating whether to add silhoutte to an existing plot (defaults to FALSE)}

\item{expansion}{Numeric containing expansion factor to multiply with body diameters. Defaults to 1 (i.e. no expansion). XXX}

\item{xoffset}{Optional value by which to shift the silhouette on the x axis}

\item{yoffset}{Optional value by which to shift the silhouette on the y axis}

\item{alpha}{Opacity value for fill of polygon (defaults to 1)}

\item{col}{Fill color of polygon (defaults to "grey")}

\item{border}{Border color of polygon (defaults to "darkgrey")}

\item{scale}{Scale to use for plotting (given in pixels/unit). Defaults to 1.}

\item{xlab}{X axis label to use for plotting (if add=FALSE)}

\item{ylab}{Y axis label to use for plotting (if add=FALSE)}

\item{...}{Other parameters to pass on to plot() or lines()}
}
\value{
A plotted silhouette
}
\description{
Plots a silhouette read by measuresil()
}
\examples{
fdir <- system.file(package="gdi")
measuresil(file.path(fdir,"exdata","lat.png"), return="all")->lat_
plot_sil(lat_)
}
