% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{bbox_transform}
\alias{bbox_transform}
\title{Transform a bounding box to a different projection}
\usage{
bbox_transform(bbox, srs_from, srs_to, use_transform_bounds = TRUE)
}
\arguments{
\item{bbox}{Numeric vector of length four containing a bounding box
(xmin, ymin, xmax, ymax) to transform.}

\item{srs_from}{Character string specifying the spatial reference system
for \code{pts}. May be in WKT format or any of the formats supported by
\code{\link[=srs_to_wkt]{srs_to_wkt()}}.}

\item{srs_to}{Character string specifying the output spatial reference
system. May be in WKT format or any of the formats supported by
\code{\link[=srs_to_wkt]{srs_to_wkt()}}.}

\item{use_transform_bounds}{Logical value, \code{TRUE} to use
\code{transform_bounds()} (the default, requires GDAL >= 3.4). If \code{FALSE},
transformation is done with \code{g_transform()}.}
}
\value{
Numeric vector of length four containing a transformed bounding box
(xmin, ymin, xmax, ymax).
}
\description{
\code{bbox_transform()} is a convenience function to transform the coordinates
of a boundary from their current spatial reference system to a new target
spatial reference system.
}
\details{
With \code{use_transform_bounds = TRUE} (the default) this function returns:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# requires GDAL >= 3.4
transform_bounds(bbox, srs_from, srs_to)
}\if{html}{\out{</div>}}

See Details for \code{\link[=transform_bounds]{transform_bounds()}} for cases where the bounds crossed the
antimeridian.

With \code{use_transform_bounds = FALSE}, this function returns:

\if{html}{\out{<div class="sourceCode">}}\preformatted{bbox_to_wkt(bbox) |>
  g_transform(srs_from, srs_to) |>
  bbox_from_wkt()
}\if{html}{\out{</div>}}

See the Note for \code{\link[=g_transform]{g_transform()}} for cases where the bounds crossed the
antimeridian.
}
\examples{
bb <- c(-1405880.72, -1371213.76, 5405880.72, 5371213.76)

# the default assumes GDAL >= 3.4
if (gdal_version_num() >= gdal_compute_version(3, 4, 0)) {
  bb_wgs84 <- bbox_transform(bb, "EPSG:32661", "EPSG:4326")
} else {
  bb_wgs84 <- bbox_transform(bb, "EPSG:32661", "EPSG:4326",
                             use_transform_bounds = FALSE)
}

print(bb_wgs84)
}
\seealso{
\code{\link[=bbox_from_wkt]{bbox_from_wkt()}}, \code{\link[=g_transform]{g_transform()}}, \code{\link[=transform_bounds]{transform_bounds()}}
}
