% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.galamm.R
\name{print.summary.galamm}
\alias{print.summary.galamm}
\title{Print method for summary GALAMM fits}
\usage{
\method{print}{summary.galamm}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{An object of class \code{summary.galamm} returned from
\code{\link{summary.galamm}}.}

\item{digits}{Number of digits to present in outputs.}

\item{...}{Further arguments passed on to other methods. Currently used by
\code{stats::printCoefmat} for printing approximate significance of smooth
terms.}
}
\value{
Summary printed to screen. Invisibly returns the argument \code{x}.
}
\description{
Print method for summary GALAMM fits
}
\examples{
# Linear mixed model with heteroscedastic residuals
mod <- galamm(
  formula = y ~ x + (1 | id),
  weights = ~ (1 | item),
  data = hsced
)

summary(mod)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=summary.galamm]{summary.galamm()}} for the summary function and \code{\link[=print]{print()}} for the
generic function.

Other summary functions: 
\code{\link{anova.galamm}()},
\code{\link{plot.galamm}()},
\code{\link{plot_smooth.galamm}()},
\code{\link{print.galamm}()},
\code{\link{summary.galamm}()}
}
\author{
Some of the code for producing summary information has been derived
from the summary methods of \code{mgcv} (author: Simon Wood) and
\code{lme4} \insertCite{batesFittingLinearMixedEffects2015}{galamm}
(authors: Douglas M. Bates, Martin Maechler, Ben Bolker, and Steve Walker).
}
\concept{summary functions}
