% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_citation.R
\name{atlas_citation}
\alias{atlas_citation}
\title{Generate a citation for occurrence data}
\usage{
atlas_citation(data)
}
\arguments{
\item{data}{A \code{tibble} generated by \code{\link[=atlas_occurrences]{atlas_occurrences()}} or similar}
}
\value{
Invisibly returns a string containing the citation for that dataset.
Primarily called for the side-effect of printing this string to the console.
}
\description{
If a \code{tibble} containing occurrences was generated using galah (either via
\code{\link[=collect.data_request]{collect()}} or \code{\link[=atlas_occurrences]{atlas_occurrences()}}), it
will usually contain associated metadata stored in \code{attributes()} that can be
used to build a citation for that dataset. This function simply extracts that
information, formats it, then both invisibly returns the formatted citation
and prints it to the console.
}
\examples{
\dontrun{
x <- galah_call() |>
    identify("Heleioporus") |>
    filter(year == 2022) |>
    collect()
atlas_citation(x)
}
}
