% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwl_plot.R
\name{fwl_plot}
\alias{fwl_plot}
\alias{fwlplot}
\title{FWL Plot}
\usage{
fwl_plot(fml, data, ggplot = FALSE, n_sample = 1000, alpha = 0.5, ...)

fwlplot(fml, data, ggplot = FALSE, n_sample = 1000, alpha = 0.5, ...)
}
\arguments{
\item{fml}{Of the form \code{y ~ x + covs | fes} following the fixest formula syntax. The x variable you want plotted should come first.}

\item{data}{A \code{dataframe} object that contains the variables in \code{fml}.}

\item{ggplot}{Boolean. Default is to use base R plot but if TRUE, use ggplot.}

\item{n_sample}{Numeric. Number of observations to sample for each facet.}

\item{alpha}{Numeric. Alpha transparency of each individual point.
If NULL, will plot all rows.}

\item{...}{Additional arguments passed to \code{fixest::feols}.}
}
\value{
Either NULL if \code{ggplot = FALSE} or a ggplot object if \code{ggplot = TRUE}. In either case, plots the figure.
}
\description{
This function creates a bivariate plot of \code{y} and \code{x} after residualizing over a set of covariates \code{w}.
}
\examples{
\donttest{
fwl_plot(mpg ~ hp + wt | cyl, mtcars)
}

}
