% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_fct_adjs.R
\name{compute_fct_adjs}
\alias{compute_fct_adjs}
\title{Calculate adjustment factors for an underlying assumption}
\usage{
compute_fct_adjs(
  .data,
  expected_rate,
  measure_sets = guess_measure_sets(.data),
  amount_scalar = NULL,
  method = c("simultaneous", "sequential"),
  cred_wt_adjs = FALSE,
  balance_adjs = FALSE,
  na.rm = FALSE
)
}
\arguments{
\item{.data}{A \code{\link[base:data.frame]{base::data.frame()}} that houses an experience study.}

\item{expected_rate}{The underlying expected rate in the experience study for which factor
adjustments are being generated for.}

\item{measure_sets}{A (potentially named) list of measure sets. Only need to specify once if
chaining multiple \code{expstudy} functions as the \code{measure_sets} will be
passed as an attribute in results.}

\item{amount_scalar}{A numeric vector to use when determining amount-weighted expecteds and
variances. The function will determine whether or not the new
expecteds/variances are amount-weighted if the corresponding actuals in
the study have values greater than 1 (actuals that are not
amount-weighted, i.e., counts, should only be 0 or 1).}

\item{method}{String indicating the method of determining factor adjustments:

\if{html}{\out{<div class="sourceCode">}}\preformatted{* `simultaneous` will calculate factor adjustments for all combinations
of group values in one iteration.
* `sequential` will calculate factor adjustments for each grouping
variable individually and applies that factor adjustment to the
underlying expected rate before continuing with the next grouping
variable's factor computation.
}\if{html}{\out{</div>}}}

\item{cred_wt_adjs}{Logical indicating if factor adjustments should be credibility-weighted
using partial credibility scores.}

\item{balance_adjs}{Logical indicating if credibility-weighted adjustments should be scaled to
produce a 100\% A/E ratio in aggregate (has no effect if
\code{cred_wt_adjs = FALSE}).}

\item{na.rm}{logical.  Should missing values (including \code{NaN}) be
    removed?}
}
\value{
A list of data frames that house factor adjustments for each measure set
provided in \code{measure_sets}.
}
\description{
There often are situations where an industry table is used for an assumed
rate due to a company lacking sufficient credibility to write their own
assumption. However, as experience becomes more available, a company would
likely want to incorporate this experience into the industry assumption
because it provides valuable insight into their own policyholders. A common
industry approach is to apply "factor adjustments" developed using company
experience to the industry assumption.
}
\details{
This function piggy-backs off of \code{measure_sets} defined in other expstudy
functions to quickly produce factor adjustments under a variety of methods.
Providing a \code{\link[dplyr:grouped_df]{dplyr::grouped_df()}} will generate factors for each group
according to the method specified. If two or more grouping variables are
provided, an additional "composite" factor adjustment will also be generated
which is the product of each individual adjustment.
}
\examples{
mortexp |>
  dplyr::group_by(
    GENDER,
    SMOKING_STATUS
  ) |>
  compute_fct_adjs(
    EXPECTED_MORTALITY_RT,
    amount_scalar = FACE_AMOUNT
  )

}
