% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_tree.R
\name{file_tree}
\alias{file_tree}
\title{file_tree: Print and Log Directory Tree Structure}
\usage{
file_tree(
  path = ".",
  max_depth = 2,
  verbose = TRUE,
  log = FALSE,
  log_path = NULL,
  file_name = NULL,
  append = FALSE
)
}
\arguments{
\item{path}{Character. The target root directory path to print. Default is ".".}

\item{max_depth}{Integer. Maximum depth of recursion into subdirectories. Default is 2.}

\item{verbose}{Logical. Whether to print the tree to console. Default is TRUE.}

\item{log}{Logical. Whether to save the tree output as a log file. Default is FALSE.}

\item{log_path}{Character. Directory path to save the log file if log = TRUE. Default is tempdir().}

\item{file_name}{Character. Custom file name for the log file. If NULL, a name like "file_tree_YYYYMMDD_HHMMSS.log" will be used.}

\item{append}{Logical. If TRUE, appends to an existing file (if present). If FALSE, overwrites the file. Default is FALSE.}
}
\value{
Invisibly returns a character vector containing each line of the file tree.
}
\description{
Print the directory structure of a given path in a tree-like format using
ASCII characters for maximum compatibility across different systems.
Optionally, save the result to a log file for record keeping or debugging.
}
\examples{
# Basic usage with current directory:
file_tree()
file_tree(".", max_depth = 3)

\donttest{
# Example with temporary directory and logging:
temp_dir <- tempdir()
file_tree(temp_dir, max_depth = 2, log = TRUE, log_path = tempdir())
}

}
