% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_url.R
\name{download_url}
\alias{download_url}
\title{download_url(): Download File from URL}
\usage{
download_url(
  url,
  dest,
  overwrite = FALSE,
  unzip = FALSE,
  verbose = TRUE,
  timeout = 600,
  headers = NULL,
  resume = FALSE,
  speed_limit = NULL,
  retries = 3
)
}
\arguments{
\item{url}{Character string. Full URL to the file to download.
Supports HTTP, HTTPS, FTP, and SFTP protocols.}

\item{dest}{Character string. Destination file path (required). Use file.path(tempdir(), basename(url)) for examples/tests.}

\item{overwrite}{Logical. Whether to overwrite existing files. Default: FALSE.}

\item{unzip}{Logical. Whether to automatically extract compressed files
after download. Supports .zip, .gz, .tar.gz formats. Default: FALSE.}

\item{verbose}{Logical. Whether to show download progress and status messages. Default: TRUE.}

\item{timeout}{Numeric. Download timeout in seconds. Default: 600 (10 minutes).}

\item{headers}{Named list. Custom HTTP headers for the request
(e.g., list(Authorization = "Bearer token")). Default: NULL.}

\item{resume}{Logical. Whether to attempt resuming interrupted downloads
if a partial file exists. Default: FALSE.}

\item{speed_limit}{Numeric. Bandwidth limit in bytes per second
(e.g., 500000 = 500KB/s). Default: NULL (no limit).}

\item{retries}{Integer. Number of retry attempts on download failure. Default: 3.}
}
\value{
Invisible character string or vector of file paths:
\describe{
\item{If unzip = FALSE}{Path to the downloaded file}
\item{If unzip = TRUE}{Vector of paths to extracted files}
}
}
\description{
Downloads files from URLs (HTTP/HTTPS/FTP/SFTP) with robust error handling,
retry mechanisms, and advanced features like resume, bandwidth limiting, and auto-extraction.
}
\details{
This function provides a comprehensive solution for downloading files with:

\subsection{Supported Protocols}{
Supports HTTP/HTTPS, FTP, and SFTP protocols.
}

\subsection{Features}{
Includes retry mechanism, resume support, bandwidth control, auto-extraction, progress tracking, and custom headers.
}

\subsection{Compression Support}{
Supports .zip, .gz, and .tar.gz formats.
}
}
\section{Dependencies}{

Required packages: curl, cli, R.utils (automatically checked at runtime).
}

\examples{
\dontrun{
# Download a CSV file from GitHub:
download_url(
  url = "https://raw.githubusercontent.com/tidyverse/ggplot2/main/README.md",
  dest = file.path(tempdir(), "ggplot2_readme.md"),
  timeout = 30
)

# Download and extract a zip file:
download_url(
  url = "https://cran.r-project.org/src/contrib/Archive/dplyr/dplyr_0.8.0.tar.gz",
  dest = file.path(tempdir(), "dplyr.tar.gz"),
  unzip = TRUE,
  timeout = 60
)
}

\donttest{
# Quick demo with a tiny file:
download_url(
  url = "https://httpbin.org/robots.txt",
  dest = file.path(tempdir(), "robots.txt"),
  timeout = 10,
  verbose = FALSE
)
}

}
