% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emld-package.R, R/emld.R
\docType{package}
\name{emld-package}
\alias{emld-package}
\title{emld: Ecological Metadata as Linked Data}
\description{
This is a utility for transforming Ecological Metadata Language ('EML') files into 'JSON-LD' and back into 'EML.' Doing so creates a list-based representation of 'EML' in R, so that 'EML' data can easily be manipulated using standard 'R' tools. This makes this package an effective backend for other 'R'-based tools working with 'EML.' By abstracting away the complexity of 'XML' Schema, developers can build around native 'R' list objects and not have to worry about satisfying many of the additional constraints of set by the schema (such as element ordering, which is handled automatically). Additionally, the 'JSON-LD' representation enables the use of developer-friendly 'JSON' parsing and serialization that may facilitate the use of 'EML' in contexts outside of 'R,' as well as the informatics-friendly serializations such as 'RDF' and 'SPARQL' queries.

The goal of emld is to provide a way to work with EML metadata
in the JSON-LD format. At it's heart, the package is simply a
way to translate an EML XML document into JSON-LD and be able
to reverse this so that any semantically equivalent JSON-LD
file can be serialized into EML-schema valid XML.
}
\details{
The package has only three core functions:
\itemize{
\item \code{\link[=as_emld]{as_emld()}} Convert EML's \code{xml} files (or the \code{json} version created
by this package) into a native R object (an S3 class called \code{emld},
essentially just a \code{list}).
\item \code{\link[=as_xml]{as_xml()}} Convert the native R format, \code{emld}, back into
XML-schema valid EML.
\item \code{\link[=as_json]{as_json()}} Convert the native R format, \code{emld}, into \code{json}(LD).
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/emld/}
  \item \url{https://github.com/ropensci/emld}
  \item Report bugs at \url{https://github.com/ropensci/emld/issues}
}


Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/emld/}
  \item \url{https://github.com/ropensci/emld}
  \item Report bugs at \url{https://github.com/ropensci/emld/issues}
}

}
\author{
\strong{Maintainer}: Carl Boettiger \email{cboettig@gmail.com} (\href{https://orcid.org/0000-0002-1642-628X}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Matthew B. Jones \email{jones@nceas.ucsb.edu} (\href{https://orcid.org/0000-0003-0077-4738}{ORCID}) [copyright holder]
  \item Bryce Mecum \email{mecum@nceas.ucsb.edu} (\href{https://orcid.org/0000-0002-0381-3766}{ORCID}) [copyright holder]
}

}
\keyword{internal}
