% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsAuth.R
\name{dsAuth}
\alias{dsAuth}
\title{Obtain an API token from dimensions.ai}
\usage{
dsAuth(
  username = NULL,
  password = NULL,
  key = NULL,
  auth_endpoint = "https://app.dimensions.ai/api/auth.json",
  verbose = FALSE
)
}
\arguments{
\item{username}{is a character.}

\item{password}{is a character.}

\item{key}{is a character.}

\item{auth_endpoint}{is a character. It contains the authentication endpoint url of Dimensions. Default is auth_endpoint = "https://app.dimensions.ai/api/auth.json"}

\item{verbose}{is logical.}
}
\value{
a character cointaining an token o use dimensions API.

To obtain a free access to Dimenions API fro no commercial use, please visit: \href{https://ds.digital-science.com/NoCostAgreement}{https://ds.digital-science.com/NoCostAgreement}

For more extensive information about Dimensions API, please visit: \href{https://www.dimensions.ai/dimensions-apis/}{https://www.dimensions.ai/dimensions-apis/}
}
\description{
It generates a token request to dimensions.ai using account and password.
}
\examples{

# Obtain a token by username and password
\dontrun{
token <- dsAuth(username = "my.email@my.domain", password = "mypassword")
}

# Obtain a token by API Key

\dontrun{
token <- dsAuth(key = "myapikey")
}

}
\seealso{
\code{\link{dsApiRequest}}

\code{\link{dsQueryBuild}}

\code{\link{dsApi2df}}
}
