% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn_functions.R
\name{ellipse.ind}
\alias{ellipse.ind}
\title{A Helper Function Used by Venn4}
\usage{
ellipse.ind(ps, x, y, a, b, alpha)
}
\arguments{
\item{ps}{a n x 2 matrix of coordinates.}

\item{x}{the x coordinate of the center of the ellipse.}

\item{y}{the y coordinate of the center of the ellipse.}

\item{a}{the x-radius of the ellipse.}

\item{b}{the y-radius of the ellipse.}

\item{alpha}{the angle of rotation of the ellipse}
}
\value{
a length n vector indicating whether each point is inside the
ellipse.
}
\description{
Takes potential points to be plotted in the venn diagrams and returns
whether the point is inside or outside of the ellipse described by x, y, a,
b, and alpha.
}
\examples{



## The function is currently defined as
ps <- cbind(runif(100), runif(100))
plot(dga:::ellipse(0, 0, .5, .3, 0), type = "l")
inds <- dga:::ellipse.ind(ps, 0, 0, .5, .3, 0)
points(inds)
}
\author{
Kristian Lum \email{kl@hrdag.org}
}
\keyword{ellipse}
