% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_deps}
\alias{install_deps}
\alias{install_dev_deps}
\title{Install package dependencies if needed.}
\usage{
install_deps(
  pkg = ".",
  dependencies = NA,
  repos = getOption("repos"),
  type = getOption("pkgType"),
  upgrade = c("default", "ask", "always", "never"),
  quiet = FALSE,
  build = TRUE,
  build_opts = c("--no-resave-data", "--no-manual", " --no-build-vignettes"),
  ...
)

install_dev_deps(
  pkg = ".",
  dependencies = TRUE,
  repos = getOption("repos"),
  type = getOption("pkgType"),
  upgrade = c("default", "ask", "always", "never"),
  quiet = FALSE,
  build = TRUE,
  build_opts = c("--no-resave-data", "--no-manual", " --no-build-vignettes"),
  ...
)
}
\arguments{
\item{pkg}{The package to use, can be a file path to the package or a
package object.  See \code{\link[=as.package]{as.package()}} for more information.}

\item{dependencies}{Which dependencies do you want to check?
Can be a character vector (selecting from "Depends", "Imports",
"LinkingTo", "Suggests", or "Enhances"), or a logical vector.

\code{TRUE} is shorthand for "Depends", "Imports", "LinkingTo" and
"Suggests". \code{NA} is shorthand for "Depends", "Imports" and "LinkingTo"
and is the default. \code{FALSE} is shorthand for no dependencies (i.e.
just check this package, not its dependencies).

The value "soft" means the same as \code{TRUE}, "hard" means the same as \code{NA}.

You can also specify dependencies from one or more additional fields,
common ones include:
\itemize{
\item Config/Needs/website - for dependencies used in building the pkgdown site.
\item Config/Needs/coverage for dependencies used in calculating test coverage.
}}

\item{repos}{A character vector giving repositories to use.}

\item{type}{Type of package to \code{update}.}

\item{upgrade}{Should package dependencies be upgraded? One of "default", "ask", "always", or "never". "default"
respects the value of the \code{R_REMOTES_UPGRADE} environment variable if set,
and falls back to "ask" if unset. "ask" prompts the user for which out of
date packages to upgrade. For non-interactive sessions "ask" is equivalent
to "always". \code{TRUE} and \code{FALSE} are also accepted and correspond to
"always" and "never" respectively.}

\item{quiet}{If \code{TRUE}, suppress output.}

\item{build}{if \code{TRUE} \code{\link[pkgbuild:build]{pkgbuild::build()}}s the package first:
this ensures that the installation is completely clean, and prevents any
binary artefacts (like \file{.o}, \code{.so}) from appearing in your local
package directory, but is considerably slower, because every compile has
to start from scratch.

One downside of installing from a built tarball is that the package is
installed from a temporary location. This means that any source references,
at R level or C/C++ level, will point to dangling locations. The debuggers
will not be able to find the sources for step-debugging. If you're
installing the package for development, consider setting \code{build} to
\code{FALSE}.}

\item{build_opts}{Options to pass to \verb{R CMD build}, only used when \code{build} is \code{TRUE}.}

\item{...}{additional arguments passed to \code{\link[remotes:install_deps]{remotes::install_deps()}}
when installing dependencies.}
}
\description{
\code{install_deps()} will install the
user dependencies needed to run the package, \code{install_dev_deps()} will also
install the development dependencies needed to test and build the package.
}
\examples{
\dontrun{install_deps(".")}
}
