% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{random.factors}
\alias{random.factors}
\alias{fixed.factors}
\title{Extract factors by type}
\usage{
random.factors(design, include_interactions = TRUE)

fixed.factors(design)
}
\arguments{
\item{design}{The factor design to check.}

\item{include_interactions}{Should random factor interactions be included?}
}
\value{
A list of factors that are either fixed or random.
}
\description{
From a given design, extract contained random or fixed factors as a list.
}
\section{Functions}{
\itemize{
\item \code{random.factors()}: Return fixed factors

}}
\examples{

des <- fixed.factor("Factor1", c("1A","1B")) +
       fixed.factor("Factor2", c("2A","2B")) +
       random.factor("Subject", c("Factor1"))
       
random.factors(des)
fixed.factors(des)

stopifnot(setequal(names(random.factors(des)), c("Subject")))
stopifnot(setequal(names(fixed.factors(des)), c("Factor1","Factor2")))


}
