% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demo_Graphic.R
\name{cont_table}
\alias{cont_table}
\title{DemoGraphic table for continuous variables}
\usage{
cont_table(var, strata, data)
}
\arguments{
\item{var}{variables}

\item{strata}{group variable with 1 = treatment and 0 = control}

\item{data}{data}
}
\value{
mean, standard deviation of treatmant and control group, smd, and p value.
}
\description{
DemoGraphic table for continuous variables
}
\examples{
set.seed(2018)
group <-round(abs(rnorm(500)*10),0) \%\% 2
cont_1 <-round(abs(rnorm(500)*10),0)
cat_multi_1 <-round(abs(rnorm(500)*10),0) \%\% 3
data_check <-data.frame(group, cont_1, cat_multi_1)
data_check$group <- factor(data_check$group, levels = c(0,1), labels = c("Control","Treatment"))
data_check$cat_multi_1 <- factor(data_check$cat_multi_1)
cont_table("cont_1","group", data_check )
}
