% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-methods-get-parameters.R
\name{get_parameters}
\alias{get_parameters}
\title{Identify parameters included in a diagnostic classification model}
\usage{
get_parameters(x, qmatrix, ..., identifier = NULL)
}
\arguments{
\item{x}{A model specification (e.g., \code{\link[=dcm_specify]{dcm_specify()}}, measurement model
(e.g., \code{\link[=lcdm]{lcdm()}}), or structural model (e.g., \code{\link[=unconstrained]{unconstrained()}}) object.}

\item{qmatrix}{The Q-matrix. A data frame with 1 row per item and 1 column
per attribute. May optionally include an additional column of item
identifiers. If an identifier column is included, this should be specified
with \code{identifier}. All cells for the remaining attribute columns should be
either 0 (item does not measure the attribute) or 1 (item does measure the
attribute).}

\item{...}{Additional arguments passed to methods.}

\item{identifier}{Optional. If present, the quoted name of the column in the
\code{qmatrix} that contains item identifiers.}
}
\value{
A \link[tibble:tibble-package]{tibble} showing the available parameter
types and coefficients for a specified model.
}
\description{
When specifying prior distributions, it is often useful to see which
parameters are included in a given model. Using the Q-matrix and type of
diagnostic model to estimated, we can create a list of all included
parameters for which a prior can be specified.
}
\examples{
qmatrix <- tibble::tibble(item = paste0("item_", 1:10),
                          att1 = sample(0:1, size = 10, replace = TRUE),
                          att2 = sample(0:1, size = 10, replace = TRUE),
                          att3 = sample(0:1, size = 10, replace = TRUE),
                          att4 = sample(0:1, size = 10, replace = TRUE))
get_parameters(dina(), qmatrix = qmatrix, identifier = "item")
}
