% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs.R
\name{fs}
\alias{fs}
\title{Feature Selection}
\usage{
fs(attribute)
}
\arguments{
\item{attribute}{Character. Name of the target variable (predictand).}
}
\value{
A \code{fs} object used as a base for feature selection strategies.
}
\description{
Base constructor for feature selection workflows. It stores the target attribute
and provides a simple transform that filters columns to the selected set.
}
\details{
Concrete strategies such as information gain, Relief, LASSO, and forward
stepwise selection are available via \code{fs_ig()}, \code{fs_relief()}, \code{fs_lasso()}, and \code{fs_fss()}.
}
\examples{
\dontrun{
# Typical usage pattern:
# 1) Choose a strategy (e.g., fs_ig for information gain)
data(iris)
fs_sel <- daltoolbox::fit(fs_ig("Species"), iris)
fs_sel$features                 # selected feature names

# 2) Apply selection to keep only chosen features + target
iris_small <- daltoolbox::transform(fs_sel, iris)
names(iris_small)
}
}
