% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{read_data}
\alias{read_data}
\title{Read delimited data for optimal use with daiquiri}
\usage{
read_data(
  file,
  delim = NULL,
  col_names = TRUE,
  quote = "\\"",
  trim_ws = TRUE,
  comment = "",
  skip = 0,
  n_max = Inf,
  show_progress = TRUE
)
}
\arguments{
\item{file}{A string containing path of file containing data to load, or a
URL starting \verb{http://}, \verb{file://}, etc. Compressed files with extension
\code{.gz}, \code{.bz2}, \code{.xz} and \code{.zip} are supported.}

\item{delim}{Single character used to separate fields within a record. E.g.
\code{","} or \code{"\\t"}}

\item{col_names}{Either \code{TRUE}, \code{FALSE} or a character vector of column
names. If \code{TRUE}, the first row of the input will be used as the column
names, and will not be included in the data frame. If \code{FALSE}, column names
will be generated automatically. Default = \code{TRUE}}

\item{quote}{Single character used to quote strings.}

\item{trim_ws}{Should leading and trailing whitespace be trimmed from each
field?}

\item{comment}{A string used to identify comments. Any text after the comment
characters will be silently ignored}

\item{skip}{Number of lines to skip before reading data. If \code{comment} is
supplied any commented lines are ignored after skipping}

\item{n_max}{Maximum number of lines to read.}

\item{show_progress}{Display a progress bar? Default = \code{TRUE}}
}
\value{
A data frame
}
\description{
Popular file readers such as \code{readr::read_delim()} perform datatype
conversion by default, which can interfere with daiquiri's ability to detect
non-conformant values. Use this function instead to ensure optimal
compatibility with daiquiri's features.
}
\details{
This function is aimed at non-expert users of R, and operates as a restricted
implementation of \code{\link[readr:read_delim]{readr::read_delim()}}. If you prefer to use \code{read_delim()}
directly, ensure you set the following parameters: \code{col_types = readr::cols(.default = "c")} and \code{na = character()}
}
\examples{
raw_data <- read_data(
  system.file("extdata", "example_prescriptions.csv", package = "daiquiri"),
  delim = ",",
  col_names = TRUE
)

head(raw_data)
}
\seealso{
\code{\link[=field_types]{field_types()}}, \code{\link[=field_types_available]{field_types_available()}},
\code{\link[=aggregate_data]{aggregate_data()}}, \code{\link[=report_data]{report_data()}},
\code{\link[=daiquiri_report]{daiquiri_report()}}
}
