% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crook_deform.R
\name{crook_deform}
\alias{crook_deform}
\title{Apply a synthetic crook/krok deformation to a stem point cloud (LAS or XYZ)}
\usage{
crook_deform(
  x,
  krok_length = 0.5,
  krok_start = 4,
  krok_type = c("2dir", "1dir"),
  krok_deviation = 0.1,
  inflektion_X = 1/4,
  inflektion_ext = 1/2,
  az = 0,
  spar = 0.8
)
}
\arguments{
\item{x}{LAS or data.frame with X,Y,Z (case-insensitive if data.frame).}

\item{krok_length}{range of the deformation along the stem's length}

\item{krok_start}{start height of the crook}

\item{krok_type}{single- or double-directional deviation}

\item{krok_deviation}{extent of the deviation}

\item{inflektion_X}{placement of double directional deviation}

\item{inflektion_ext}{placement of double directional deviation}

\item{az}{numeric degrees. Azimuth of lateral rotation (0 = X axis, 90 = Y axis). Default 0.}

\item{spar}{smoothing parameter for \code{stats::smooth.spline} (0..1).}
}
\value{
Same class as input (LAS or data.frame object with crook deformation)
}
\description{
Generalization of your \code{Create_Krok()} that supports \code{lidR::LAS} or
data.frames, arbitrary azimuth, and safer handling of edge cases.
}
