% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update.cpforecast}
\alias{update.cpforecast}
\title{Update and repeform cross-validation forecasting and conformal prediction}
\usage{
\method{update}{cpforecast}(object, new_data, forecastfun, new_xreg = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{"cpforecast"}.}

\item{new_data}{A vector of newly available data.}

\item{forecastfun}{Function to return an object of class \code{"forecast"}.
Its first argument must be a univariate time series, and it must have an
argument \code{h} for the forecast horizon and an argument \code{level} for
the confidence level for prediction intervals. If exogenous predictors are used,
then it must also have \code{xreg} and \code{newxreg} arguments corresponding
to the training and test periods, respectively.}

\item{new_xreg}{Newly available exogenous predictor variables passed to
\code{forecastfun} if required. The number of rows should match the length of
\code{new_data}, and the number of columns should match the dimensions of
the \code{xreg} argument in \code{object}.}

\item{...}{Other arguments are passed to \code{forecastfun}.}
}
\value{
A refreshed object of class \code{"cpforecast"} with updated fields (e.g.,
\code{x}, \code{MEAN}, \code{ERROR}, \code{LOWER}, \code{UPPER}, and any
method-specific components), reflecting newly appended data and re-computed
cross-validation forecasts and conformal prediction intervals.
}
\description{
Update conformal prediction intervals and other information by applying the
\code{cvforecast} and \code{conformal} functions.
}
\examples{
# Simulate time series from an AR(2) model
library(forecast)
series <- arima.sim(n = 200, list(ar = c(0.8, -0.5)), sd = sqrt(1))

# Cross-validation forecasting
far2 <- function(x, h, level) {
  Arima(x, order = c(2, 0, 0)) |>
    forecast(h = h, level)
}
fc <- cvforecast(series, forecastfun = far2, h = 3, level = 95,
                 forward = TRUE, initial = 1, window = 50)

# Classical conformal prediction with equal weights
scpfc <- conformal(fc, method = "scp", symmetric = FALSE, ncal = 50, rolling = TRUE)

# Update conformal prediction using newly available data
scpfc_update <- update(scpfc, forecastfun = far2, new_data = c(1.5, 0.8, 2.3))
print(scpfc_update)
summary(scpfc_update)

}
