% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_nonparametric.R
\name{tuneBSuninonpar}
\alias{tuneBSuninonpar}
\title{Wild binary segmentation for univariate nonparametric change points detection with tuning parameter selection.}
\usage{
tuneBSuninonpar(BS_object, Y, N)
}
\arguments{
\item{BS_object}{A "BS" object produced by \code{BS.uni.nonpar} or \code{WBS.uni.nonpar}.}

\item{Y}{A \code{numeric} matrix of observations with horizontal axis being time, and vertical axis being multiple observations on each time point.}

\item{N}{A \code{integer} vector representing number of multiple observations on each time point.}
}
\value{
A vector of estimated change points (sorted in strictly increasing order).
}
\description{
Perform wild binary segmentation with tuning parameter selection based on sample splitting.
}
\examples{
Y = t(as.matrix(c(rnorm(100, 0, 1), rnorm(100, 0, 10), rnorm(50, 0, 40))))
W = Y # W is a copy of the matrix Y, it can be Y itself.
N = rep(1, 250)
M = 5
set.seed(123)
intervals = WBS.intervals(M = M, lower = 1, upper = ncol(Y))
BS_object = WBS.uni.nonpar(W, 1, ncol(Y), intervals$Alpha, intervals$Beta, N, delta = 5)
cpt_hat = tuneBSuninonpar(BS_object, Y, N)
}
\references{
Padilla, Yu, Wang and Rinaldo (2021) <doi:10.1214/21-EJS1809>.
}
\seealso{
\code{\link{BS.uni.nonpar}} and \code{\link{WBS.uni.nonpar}}.
}
\author{
Oscar Hernan Madrid Padilla & Haotian Xu
}
