% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HD_regression.R
\name{local.refine.DPDU.regression}
\alias{local.refine.DPDU.regression}
\title{Local refinement for DPDU regression change points localisation.}
\usage{
local.refine.DPDU.regression(cpt_init, beta_hat, y, X, w = 0.9)
}
\arguments{
\item{cpt_init}{An \code{integer} vector of initial changepoints estimation (sorted in strictly increasing order).}

\item{beta_hat}{A \code{numeric} (px(K_hat+1))matrix of estimated regression coefficients.}

\item{y}{A \code{numeric} vector of response variable.}

\item{X}{A \code{numeric} matrix of covariates with vertical axis being time..}

\item{w}{A \code{numeric} scalar in (0,1) representing the weight for interval truncation.}
}
\value{
A vector of locally refined change points estimation.
}
\description{
Perform local refinement for regression change points localisation.
}
\examples{
d0 = 5
p = 30
n = 200
cpt_true = 100
data = simu.change.regression(d0, cpt_true, p, n, sigma = 1, kappa = 9)
lambda_set = c(0.01, 0.1, 1, 2)
zeta_set = c(10, 15, 20)
temp = CV.search.DPDU.regression(y = data$y, X = data$X, lambda_set, zeta_set)
temp$test_error # test error result
# find the indices of lambda_set and zeta_set which minimizes the test error
min_idx = as.vector(arrayInd(which.min(temp$test_error), dim(temp$test_error))) 
lambda_set[min_idx[2]]
zeta_set[min_idx[1]]
cpt_init = unlist(temp$cpt_hat[min_idx[1], min_idx[2]])
beta_hat = matrix(unlist(temp$beta_hat[min_idx[1], min_idx[2]]), ncol = length(cpt_init)+1)
cpt_refined = local.refine.DPDU.regression(cpt_init, beta_hat, data$y, data$X, w = 0.9)
}
\references{
Xu, Wang, Zhao and Yu (2022) <arXiv:2207.12453>.

Xu, Wang, Zhao and Yu (2022) <arXiv:2207.12453>.
}
\author{
Haotian Xu
}
