% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_mean_robust.R
\name{aARC}
\alias{aARC}
\title{Automatic adversarially robust univariate mean change point detection.}
\usage{
aARC(y, t_dat, guess_true = 0.05, h, block_num = 1)
}
\arguments{
\item{y}{A \code{numeric} vector of observations.}

\item{t_dat}{A \code{numeric} vector of observations that is used to select epsilon in the Huber contamination model.}

\item{guess_true}{A \code{numeric} scalar representing a guess of epsilon value.}

\item{h}{An \code{integer} scalar representing block size.}

\item{block_num}{An \code{integer} scalar representing number of blocks used when searching for local maximiser.}
}
\value{
An \code{numeric} vector of estimated change point locations.
}
\description{
Perform the adversarially robust change point detection method with automatic selection of the contamination proportion epsilon when treating the inliner distributions as Gaussian.
}
\examples{
#' ### simulate data with contamination
obs_num = 1000
D = 2
noise = 0.1 # proportion of contamination
mu0 = 0
mu1 = 1
sd =1
idmixture = rbinom(obs_num/D, 1, 1-noise)
dat = NULL
for (j in 1:D){
  for (i in 1:(obs_num/(2*D))){
    if (idmixture[i] == 1){
      dat = c(dat,rnorm(1,mu0,sd))
    }
    else{
      dat = c(dat,rnorm(1,mu1/(2*noise),0))
    }
  }
  for (i in (obs_num/(2*D)+1):(obs_num/D)){
    if (idmixture[i] == 1){
      dat = c(dat,rnorm(1,mu1,sd))
    }
    else{
      dat = c(dat,rnorm(1,mu1/(2*noise)-(1-noise)*mu1/noise,0))
    }
  }
}
plot(dat)
### perform aARC
aARC(dat, dat[1:200], h = 120)
}
\references{
Li and Yu (2021) <arXiv:2105.10417>.
}
\author{
Mengchu Li
}
