% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{pyr_trends}
\alias{pyr_trends}
\title{Build Population Pyramid Trends}
\usage{
pyr_trends(data, mode = 1, use_prop = FALSE, color = "Fresh and bright")
}
\arguments{
\item{data}{A data frame of population data for a specific region across
census years, containing at least:
\code{year}, \code{age5}, \code{sex}, and \code{pop}.}

\item{mode}{Integer; visualization mode: \code{1} for grid pyramids, \code{2}
for overlayed age profiles. Default is \code{1}.}

\item{use_prop}{Logical; whether to show proportions instead of absolute
counts. Default is \code{FALSE}.}

\item{color}{Character; the name of a Canva color palette available in
\code{ggthemes::canva_palettes}. Default is \code{"Fresh and bright"}.}
}
\value{
A \code{ggplot2} object representing the population pyramid trend plot.
}
\description{
Create trend plots of population pyramids over multiple census years for a
given region. Users can choose between a grid layout of pyramids or an
overlay of age profiles across years.
}
\details{
Two visualization modes are available:
\itemize{
\item \code{mode = 1}: Grid of population pyramids (faceted by year).
\item \code{mode = 2}: Overlayed age profiles with separate lines by year.
}

Population counts can be displayed either as absolute numbers (default, in
thousands) or as proportions (\code{use_prop = TRUE}).
}
\examples{
\dontrun{
# Example: pyramid trends for Indonesia
data_idn <- load_pop_data(harmonized = TRUE, smoothing = 1) |>
  pop_data_by_reg(0) #Indonesia
pyr_trends(data_idn, mode = 1)  # grid layout

# Overlay mode with proportions
pyr_trends(data_idn, mode = 2, use_prop = TRUE)
}

}
\seealso{
\code{\link[=area_trends]{area_trends()}}, \code{\link[=load_pop_data]{load_pop_data()}}, \code{\link[=pop_data_by_reg]{pop_data_by_reg()}}, \code{\link[=get_code_label]{get_code_label()}}
}
