% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{load_pop_data}
\alias{load_pop_data}
\title{Load Population Data}
\usage{
load_pop_data(harmonized = TRUE, smoothing = 1)
}
\arguments{
\item{harmonized}{Logical. If \code{TRUE} (default), load harmonized data
(\code{hpop5}). If \code{FALSE}, load non-harmonized data (\code{ypop5}).}

\item{smoothing}{Integer. Smoothing method applied to population counts:
\itemize{
\item \code{1}: none (raw)
\item \code{2}: Arriaga
\item \code{3}: Karup–King–Newton (KKN)
}}
}
\value{
A tibble with columns:
\itemize{
\item \code{year}: census year
\item \code{province_id}: province identifier (harmonized or non-harmonized)
\item \code{sex}: sex code
\item \code{age5}: five-year age group code
\item \code{pop}: population count (raw or smoothed)
}
}
\description{
Load census population data with options for harmonization and smoothing.
Returns population counts by year, province, sex, and five-year age group,
with raw or smoothed estimates depending on the selected method.
}
\details{
Data are retrieved from internal census datasets:
\itemize{
\item \code{hpop5}: harmonized census data
\item \code{ypop5}: non-harmonized census data
}

Smoothing methods are applied to the population counts:
\itemize{
\item \code{1}: none (raw, default)
\item \code{2}: Arriaga method
\item \code{3}: Karup–King–Newton (KKN) method
}
}
\examples{
\dontrun{
# Load harmonized, raw (unsmoothed) population data
load_pop_data(harmonized = TRUE, smoothing = 1)

# Load non-harmonized, Arriaga-smoothed population data
load_pop_data(harmonized = FALSE, smoothing = 2)
}

}
\seealso{
\code{\link[=pop_data_by_year]{pop_data_by_year()}}, \code{\link[=pop_data_by_reg]{pop_data_by_reg()}}, \link{pop5}
}
