% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{neuro_cat}
\alias{neuro_cat}
\title{Neuroticism Cat Object}
\format{
An object of class \code{Cat} of length 1.
}
\source{
See \code{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.
}
\usage{
data(neuro_cat)
}
\description{
Cat object containing item parameters for graded response model fit with responses to the 20-item Neuroticism dimension of the 
100-item IPIP representation of Costa and McCrae's Five Factor Model
}
\details{
Cat object containing item parameters for graded response model fit with
 774,410 response profiles by myPersonality Project and 1500 response profiles
collected by YouGov in June 2018.  The sample from myPersonality Project was a convenience sample, and the
respondents from YouGov were matched to a sampling frame on gender, age, race, and education.

See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{grmCat}} for details regarding the graded response model.

A normal prior was chosen with mean from the theta estimates from the YouGov sample (-.025) and a standard deviation (1.2)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Response options are 1=Very inaccurate; 2=Moderately inaccurate; 3=Neither inaccurate nor accurate;
4=Moderately accurate; 5=Very accurate.

The wording of the question items:

I...
\describe{
\item{\code{q12}}{Often feel blue.}
\item{\code{q30}}{Dislike myself.}
\item{\code{q80}}{Am often down in the dumps.}
\item{\code{q70}}{Have frequent mood swings.}
\item{\code{q50}}{Panic easily.}
\item{\code{q90}}{Am filled with doubts about things.}
\item{\code{q100}}{Feel threatened easily.}
\item{\code{q17}}{Get stressed out easily.}
\item{\code{q40}}{Fear for the worst.}
\item{\code{q60}}{Worry about things.}
\item{\code{q37}}{Seldom feel blue.}
\item{\code{q11}}{Feel comfortable with myself.}
\item{\code{q67}}{Rarely get irritated.}
\item{\code{q19}}{Am not easily bothered by things.}
\item{\code{q97}}{Am very pleased with myself.}
\item{\code{q27}}{Am relaxed most of the time.}
\item{\code{q77}}{Seldom get mad.}
\item{\code{q47}}{Am not easily frustrated.}
\item{\code{q87}}{Remain calm under pressure.}
\item{\code{q57}}{Rarely lose my composure.}
}
}
\references{
Costa, P. T., Jr., & McCrae, R. R. (1992). Revised NEO Personality Inventory (NEO PI-R)
and NEO Five-Factor Inventory (NEO-FFI): Professional manual. Odessa, FL: Psychological Assessment Resources.

Stillwell, David, and Michal Kosinski. 2007. "myPersonality Project."
\url{https://sites.google.com/michalkosinski.com/mypersonality}
}
\seealso{
\code{\link{Cat-class}}, \code{\link{grmCat}}
}
\keyword{datasets}
