% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gpcm_cat}
\alias{gpcm_cat}
\title{gpcm Cat Object}
\format{
An object of class \code{Cat}.  See \code{\link{Cat-class}} for more details.
}
\usage{
data(gpcm_cat)
}
\description{
An object of class \code{Cat} created using the \code{gpcmCat} function with the \code{polknowTAPS} dataset.
To have a better fitting model, we first fit an object of class \code{gpcm} from the \code{ltm} package which
provides for additional control values to be used in fitting.  See \code{gpcmCat}.
}
\examples{
\dontrun{
## How this Cat object was created
data(polknowTAPS)
gpcm_fit <- gpcm(polknowTAPS, constraint = "gpcm", control = list(iter.qN = 200, GHk = 100))
gpcm_cat <- gpcmCat(gpcm_fit)
}

## How to load this Cat object for usage
data(gpcm_cat)

}
\seealso{
\code{\link{Cat-class}}, \code{\link{gpcmCat}}, \code{\link{polknowTAPS}}
}
\keyword{datasets}
