% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa02_broadcast_casting.R
\name{aaa02_broadcast_casting}
\alias{aaa02_broadcast_casting}
\alias{broadcast_casting}
\title{Details on Casting Functions}
\description{
'broadcast' provides several "casting" functions. \cr
These can facilitate complex forms of broadcasting that would normally not be possible. \cr
But these "casting" functions also have their own merit, beside empowering complex broadcasting. \cr
\cr
The following casting functions are available:
\itemize{
\item \link{acast}: \cr
Casts group-based subsets of an array into a new dimension. \cr
Useful for, for example, performing \bold{grouped} broadcasted operations.
\item \link{cast_hier2dim}: \cr
Casts a nested/hierarchical list into a dimensional list (i.e. array of type \code{list}). \cr
Useful because one cannot broadcast through nesting, but one \bold{can} broadcast along dimensions.
\item \link{hier2dim}, \link{hiernames2dimnames}: \cr
Helper functions for \link{cast_hier2dim}.
\item \link{cast_dim2hier}: \cr
Casts a dimensional list into a nested/hierarchical list; the opposite of \link{cast_hier2dim}.
\item \link{cast_shallow2atomic}: \cr
Casts a (dimensional) shallow (i.e. non-nested) list into an atomic vector or array. \cr
Useful because atomic vectors/arrays have access to many vectorized (broadcasted) operations that may not be available for vectors/arrays of type \code{list}.
\item \link{cast_dim2flat}: \cr
Casts a dimensional list into a flattened list, but with names that indicate their original dimensional positions. \cr
Mostly useful for printing or summarizing dimensional lists.
\item \link{dropnests}: \cr
Drop redundant nesting in lists; mostly used for facilitating the above casting functions. \cr \cr
}
}
\section{Shared argument \code{recurse_all}}{

The \link{dropnests}, \link{hier2dim}, \link{hiernames2dimnames}, and \link{cast_hier2dim} methods
all have the \code{recurse_all} argument. \cr
By default \code{recurse_all = FALSE},
meaning these methods do not recurse through dimensional or classed lists (like data.frames). \cr
Setting \code{recurse_all = TRUE}
allows these methods to recurse through all list objects,
even if they are dimensional and/or classed. \cr
\cr
}

\section{Shared Argument \code{in2out}}{

The \link{hier2dim}, \link{hiernames2dimnames}, \link{cast_hier2dim}, and \link{cast_dim2hier} methods
all have the \code{in2out} argument. \cr
\cr
\cr
\ifelse{html}{\figure{in2out-TRUE-green.svg}{options: alt='[TRUE]'}}{\link[=broadcast_casting]{in2out}: TRUE; } \cr
By default \code{in2out} is \code{TRUE}. \cr
This means the call \cr
\code{y <- cast_hier2dim(x)} \cr
will cast the elements of the deepest valid depth of \code{x} to the rows of \code{y},
and elements of the depth above that to the columns of \code{y},
and so on until the surface-level elements of \code{x} are cast to the last dimension of \code{y}. \cr
\cr
Similarly, the call \cr
\code{x <- cast_dim2hier(y)} \cr
will cast the rows of \code{y} to the inner most elements of \code{x},
and the columns of \code{y} to one depth above that,
and so on until the last dimension of \code{y} is cast to the surface-level elements of \code{x}. \cr
\cr
Consider the nested list \code{x} with a depth of \code{3},
and the recursive array \code{y} with 3 dimensions,
where their relationship can described as the following code: \cr
\code{y <- cast_hier2dim(x)} \cr
\code{x <- cast_dim2hier(y)}. \cr
Then it holds that: \cr
\code{x[[i]][[j]][[k]]} corresponds to \code{y[[k, j, i]]}, \cr
\eqn{\forall}(\code{i}, \code{j}, \code{k}) , provided \code{x[[i]][[j]][[k]]} exists. \cr
\cr
\cr
\ifelse{html}{\figure{in2out-FALSE-red.svg}{options: alt='[FALSE]'}}{\link[=broadcast_casting]{in2out}: FALSE; } \cr
If \code{in2out = FALSE}, the call \cr
\code{y <- cast_hier2dim(x, in2out = FALSE)} \cr
will cast the surface-level elements of \code{x} to the rows of \code{y},
and elements of the depth below that to the columns of \code{y},
and so on until the elements of the deepest valid depth of \code{x} are cast to the last dimension of \code{y}. \cr
\cr
Similarly, the call \cr
\code{x <- cast_dim2hier(y, in2out = FALSE)} \cr
will cast the rows of \code{y} to the surface-level elements of \code{x},
and the columns of \code{y} to one depth below that,
and so on until the last dimension of \code{y} is cast to the inner most elements of \code{x}. \cr
\cr
Consider the nested list \code{x} with a depth of \code{3},
and the recursive array \code{y} with 3 dimensions,
where their relationship can described with the following code: \cr
\code{y <- cast_hier2dim(x, in2out = FALSE)} \cr
\code{x <- cast_dim2hier(y, in2out = FALSE)}. \cr
Then it holds that : \cr
\code{x[[i]][[j]][[k]]} corresponds to \code{y[[i, j, k]]}, \cr
\eqn{\forall}(\code{i}, \code{j}, \code{k}) , provided \code{x[[i]][[j]][[k]]} exists. \cr \cr
}

\examples{

# recurse_all demonstration ====
x <- list(
  a = list(list(list(list(1:10)))),
  b = data.frame(month.abb, month.name),
  c = data.frame(month.abb),
  d = array(list(1), c(1,1,1))
)

dropnests(x) # by default, recurse_all = FALSE

dropnests(x, recurse_all = TRUE) # recurse_all = TRUE



# in2out demonstration ====
x <- list(
  group1 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  ),
  group2 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  )
)

# in2out = TRUE (default):
x2 <- cast_hier2dim(x)
dimnames(x2) <- hiernames2dimnames(x)
print(x2)
cast_dim2flat(x2[1,1,,drop = FALSE])

# in2out = FALSE:
x2 <- cast_hier2dim(x, in2out = FALSE)
dimnames(x2) <- hiernames2dimnames(x, in2out = FALSE)
print(x2)
cast_dim2flat(x2[1,1,,drop = FALSE])

}
