% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{insert_NAs}
\alias{insert_NAs}
\title{Insert NA gaps to regularize a time series}
\usage{
insert_NAs(data, int, units)
}
\arguments{
\item{data}{A data frame that minimally contains columns for animal ID, date,
and time step. These must be labeled \code{id}, \code{date}, and \code{dt},
respectively, where date is of class \code{POSIXct}.}

\item{int}{integer. An integer that characterizes the desired interval on
which to insert new rows.}

\item{units}{character. The units of the selected time interval \code{int},
which can be selected from one of "secs", "mins", "hours", "days", or
"weeks".}
}
\value{
A data frame where new rows have been inserted to regularize the \code{date} column. This results in values provided for \code{id}, \code{date}, and \code{dt} while inserting NAs for all other columns. Additionally, observations with duplicate date-times are removed.
}
\description{
Insert NA gaps to regularize a time series
}
\examples{
#load data
data(tracks)

#remove rows to show how function works (create irregular time series)
set.seed(1)
ind<- sort(sample(2:15003, 500))

tracks.red<- tracks[-ind,]

#calculate step lengths, turning angles, net-squared displacement, and time steps
tracks.red<- prep_data(dat = tracks.red, coord.names = c("x","y"), id = "id")

#round times to nearest interval
tracks.red<- round_track_time(dat = tracks.red, id = "id", int = c(3600, 7200, 10800, 14400),
                              tol = 300, units = "secs")

#insert NA gaps
dat.out<- insert_NAs(tracks.red, int = 3600, units = "secs")


}
